import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ImportVolumeRequest, ImportVolumeResult } from "../models/models_5";
export interface ImportVolumeCommandInput extends ImportVolumeRequest {
}
export interface ImportVolumeCommandOutput extends ImportVolumeResult, __MetadataBearer {
}

export declare class ImportVolumeCommand extends $Command<ImportVolumeCommandInput, ImportVolumeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ImportVolumeCommandInput;
    constructor(input: ImportVolumeCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ImportVolumeCommandInput, ImportVolumeCommandOutput>;
    private serialize;
    private deserialize;
}
