import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ImportInstanceRequest, ImportInstanceResult } from "../models/models_5";
export interface ImportInstanceCommandInput extends ImportInstanceRequest {
}
export interface ImportInstanceCommandOutput extends ImportInstanceResult, __MetadataBearer {
}

export declare class ImportInstanceCommand extends $Command<ImportInstanceCommandInput, ImportInstanceCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ImportInstanceCommandInput;
    constructor(input: ImportInstanceCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ImportInstanceCommandInput, ImportInstanceCommandOutput>;
    private serialize;
    private deserialize;
}
