import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetManagedPrefixListEntriesRequest, GetManagedPrefixListEntriesResult } from "../models/models_5";
export interface GetManagedPrefixListEntriesCommandInput extends GetManagedPrefixListEntriesRequest {
}
export interface GetManagedPrefixListEntriesCommandOutput extends GetManagedPrefixListEntriesResult, __MetadataBearer {
}

export declare class GetManagedPrefixListEntriesCommand extends $Command<GetManagedPrefixListEntriesCommandInput, GetManagedPrefixListEntriesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetManagedPrefixListEntriesCommandInput;
    constructor(input: GetManagedPrefixListEntriesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetManagedPrefixListEntriesCommandInput, GetManagedPrefixListEntriesCommandOutput>;
    private serialize;
    private deserialize;
}
