import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetDefaultCreditSpecificationRequest, GetDefaultCreditSpecificationResult } from "../models/models_4";
export interface GetDefaultCreditSpecificationCommandInput extends GetDefaultCreditSpecificationRequest {
}
export interface GetDefaultCreditSpecificationCommandOutput extends GetDefaultCreditSpecificationResult, __MetadataBearer {
}

export declare class GetDefaultCreditSpecificationCommand extends $Command<GetDefaultCreditSpecificationCommandInput, GetDefaultCreditSpecificationCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetDefaultCreditSpecificationCommandInput;
    constructor(input: GetDefaultCreditSpecificationCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetDefaultCreditSpecificationCommandInput, GetDefaultCreditSpecificationCommandOutput>;
    private serialize;
    private deserialize;
}
