import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetConsoleOutputRequest, GetConsoleOutputResult } from "../models/models_4";
export interface GetConsoleOutputCommandInput extends GetConsoleOutputRequest {
}
export interface GetConsoleOutputCommandOutput extends GetConsoleOutputResult, __MetadataBearer {
}

export declare class GetConsoleOutputCommand extends $Command<GetConsoleOutputCommandInput, GetConsoleOutputCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetConsoleOutputCommandInput;
    constructor(input: GetConsoleOutputCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetConsoleOutputCommandInput, GetConsoleOutputCommandOutput>;
    private serialize;
    private deserialize;
}
