import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeRegionsRequest, DescribeRegionsResult } from "../models/models_3";
export interface DescribeRegionsCommandInput extends DescribeRegionsRequest {
}
export interface DescribeRegionsCommandOutput extends DescribeRegionsResult, __MetadataBearer {
}

export declare class DescribeRegionsCommand extends $Command<DescribeRegionsCommandInput, DescribeRegionsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeRegionsCommandInput;
    constructor(input: DescribeRegionsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeRegionsCommandInput, DescribeRegionsCommandOutput>;
    private serialize;
    private deserialize;
}
