import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeInstancesRequest, DescribeInstancesResult } from "../models/models_3";
export interface DescribeInstancesCommandInput extends DescribeInstancesRequest {
}
export interface DescribeInstancesCommandOutput extends DescribeInstancesResult, __MetadataBearer {
}

export declare class DescribeInstancesCommand extends $Command<DescribeInstancesCommandInput, DescribeInstancesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeInstancesCommandInput;
    constructor(input: DescribeInstancesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeInstancesCommandInput, DescribeInstancesCommandOutput>;
    private serialize;
    private deserialize;
}
