import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeInstanceStatusRequest, DescribeInstanceStatusResult } from "../models/models_3";
export interface DescribeInstanceStatusCommandInput extends DescribeInstanceStatusRequest {
}
export interface DescribeInstanceStatusCommandOutput extends DescribeInstanceStatusResult, __MetadataBearer {
}

export declare class DescribeInstanceStatusCommand extends $Command<DescribeInstanceStatusCommandInput, DescribeInstanceStatusCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeInstanceStatusCommandInput;
    constructor(input: DescribeInstanceStatusCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeInstanceStatusCommandInput, DescribeInstanceStatusCommandOutput>;
    private serialize;
    private deserialize;
}
