import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeInstanceAttributeRequest, InstanceAttribute } from "../models/models_3";
export interface DescribeInstanceAttributeCommandInput extends DescribeInstanceAttributeRequest {
}
export interface DescribeInstanceAttributeCommandOutput extends InstanceAttribute, __MetadataBearer {
}

export declare class DescribeInstanceAttributeCommand extends $Command<DescribeInstanceAttributeCommandInput, DescribeInstanceAttributeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeInstanceAttributeCommandInput;
    constructor(input: DescribeInstanceAttributeCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeInstanceAttributeCommandInput, DescribeInstanceAttributeCommandOutput>;
    private serialize;
    private deserialize;
}
