import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeHostsRequest, DescribeHostsResult } from "../models/models_3";
export interface DescribeHostsCommandInput extends DescribeHostsRequest {
}
export interface DescribeHostsCommandOutput extends DescribeHostsResult, __MetadataBearer {
}

export declare class DescribeHostsCommand extends $Command<DescribeHostsCommandInput, DescribeHostsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeHostsCommandInput;
    constructor(input: DescribeHostsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeHostsCommandInput, DescribeHostsCommandOutput>;
    private serialize;
    private deserialize;
}
