import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteIpamScopeRequest, DeleteIpamScopeResult } from "../models/models_2";
export interface DeleteIpamScopeCommandInput extends DeleteIpamScopeRequest {
}
export interface DeleteIpamScopeCommandOutput extends DeleteIpamScopeResult, __MetadataBearer {
}

export declare class DeleteIpamScopeCommand extends $Command<DeleteIpamScopeCommandInput, DeleteIpamScopeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteIpamScopeCommandInput;
    constructor(input: DeleteIpamScopeCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteIpamScopeCommandInput, DeleteIpamScopeCommandOutput>;
    private serialize;
    private deserialize;
}
