import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteIpamRequest, DeleteIpamResult } from "../models/models_2";
export interface DeleteIpamCommandInput extends DeleteIpamRequest {
}
export interface DeleteIpamCommandOutput extends DeleteIpamResult, __MetadataBearer {
}

export declare class DeleteIpamCommand extends $Command<DeleteIpamCommandInput, DeleteIpamCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteIpamCommandInput;
    constructor(input: DeleteIpamCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteIpamCommandInput, DeleteIpamCommandOutput>;
    private serialize;
    private deserialize;
}
