import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteFlowLogsRequest, DeleteFlowLogsResult } from "../models/models_2";
export interface DeleteFlowLogsCommandInput extends DeleteFlowLogsRequest {
}
export interface DeleteFlowLogsCommandOutput extends DeleteFlowLogsResult, __MetadataBearer {
}

export declare class DeleteFlowLogsCommand extends $Command<DeleteFlowLogsCommandInput, DeleteFlowLogsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteFlowLogsCommandInput;
    constructor(input: DeleteFlowLogsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteFlowLogsCommandInput, DeleteFlowLogsCommandOutput>;
    private serialize;
    private deserialize;
}
