import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateVolumeRequest, Volume } from "../models/models_2";
export interface CreateVolumeCommandInput extends CreateVolumeRequest {
}
export interface CreateVolumeCommandOutput extends Volume, __MetadataBearer {
}

export declare class CreateVolumeCommand extends $Command<CreateVolumeCommandInput, CreateVolumeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateVolumeCommandInput;
    constructor(input: CreateVolumeCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateVolumeCommandInput, CreateVolumeCommandOutput>;
    private serialize;
    private deserialize;
}
