import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateStoreImageTaskRequest, CreateStoreImageTaskResult } from "../models/models_1";
export interface CreateStoreImageTaskCommandInput extends CreateStoreImageTaskRequest {
}
export interface CreateStoreImageTaskCommandOutput extends CreateStoreImageTaskResult, __MetadataBearer {
}

export declare class CreateStoreImageTaskCommand extends $Command<CreateStoreImageTaskCommandInput, CreateStoreImageTaskCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateStoreImageTaskCommandInput;
    constructor(input: CreateStoreImageTaskCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateStoreImageTaskCommandInput, CreateStoreImageTaskCommandOutput>;
    private serialize;
    private deserialize;
}
