import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateSnapshotsRequest, CreateSnapshotsResult } from "../models/models_1";
export interface CreateSnapshotsCommandInput extends CreateSnapshotsRequest {
}
export interface CreateSnapshotsCommandOutput extends CreateSnapshotsResult, __MetadataBearer {
}

export declare class CreateSnapshotsCommand extends $Command<CreateSnapshotsCommandInput, CreateSnapshotsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateSnapshotsCommandInput;
    constructor(input: CreateSnapshotsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateSnapshotsCommandInput, CreateSnapshotsCommandOutput>;
    private serialize;
    private deserialize;
}
