import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateIpamScopeRequest, CreateIpamScopeResult } from "../models/models_1";
export interface CreateIpamScopeCommandInput extends CreateIpamScopeRequest {
}
export interface CreateIpamScopeCommandOutput extends CreateIpamScopeResult, __MetadataBearer {
}

export declare class CreateIpamScopeCommand extends $Command<CreateIpamScopeCommandInput, CreateIpamScopeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateIpamScopeCommandInput;
    constructor(input: CreateIpamScopeCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateIpamScopeCommandInput, CreateIpamScopeCommandOutput>;
    private serialize;
    private deserialize;
}
