import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateInstanceExportTaskRequest, CreateInstanceExportTaskResult } from "../models/models_1";
export interface CreateInstanceExportTaskCommandInput extends CreateInstanceExportTaskRequest {
}
export interface CreateInstanceExportTaskCommandOutput extends CreateInstanceExportTaskResult, __MetadataBearer {
}

export declare class CreateInstanceExportTaskCommand extends $Command<CreateInstanceExportTaskCommandInput, CreateInstanceExportTaskCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateInstanceExportTaskCommandInput;
    constructor(input: CreateInstanceExportTaskCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateInstanceExportTaskCommandInput, CreateInstanceExportTaskCommandOutput>;
    private serialize;
    private deserialize;
}
