import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CancelSpotInstanceRequestsRequest, CancelSpotInstanceRequestsResult } from "../models/models_0";
export interface CancelSpotInstanceRequestsCommandInput extends CancelSpotInstanceRequestsRequest {
}
export interface CancelSpotInstanceRequestsCommandOutput extends CancelSpotInstanceRequestsResult, __MetadataBearer {
}

export declare class CancelSpotInstanceRequestsCommand extends $Command<CancelSpotInstanceRequestsCommandInput, CancelSpotInstanceRequestsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CancelSpotInstanceRequestsCommandInput;
    constructor(input: CancelSpotInstanceRequestsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CancelSpotInstanceRequestsCommandInput, CancelSpotInstanceRequestsCommandOutput>;
    private serialize;
    private deserialize;
}
