import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { AttachNetworkInterfaceRequest, AttachNetworkInterfaceResult } from "../models/models_0";
export interface AttachNetworkInterfaceCommandInput extends AttachNetworkInterfaceRequest {
}
export interface AttachNetworkInterfaceCommandOutput extends AttachNetworkInterfaceResult, __MetadataBearer {
}

export declare class AttachNetworkInterfaceCommand extends $Command<AttachNetworkInterfaceCommandInput, AttachNetworkInterfaceCommandOutput, EC2ClientResolvedConfig> {
    readonly input: AttachNetworkInterfaceCommandInput;
    constructor(input: AttachNetworkInterfaceCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<AttachNetworkInterfaceCommandInput, AttachNetworkInterfaceCommandOutput>;
    private serialize;
    private deserialize;
}
