import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { AssociateAddressRequest, AssociateAddressResult } from "../models/models_0";
export interface AssociateAddressCommandInput extends AssociateAddressRequest {
}
export interface AssociateAddressCommandOutput extends AssociateAddressResult, __MetadataBearer {
}

export declare class AssociateAddressCommand extends $Command<AssociateAddressCommandInput, AssociateAddressCommandOutput, EC2ClientResolvedConfig> {
    readonly input: AssociateAddressCommandInput;
    constructor(input: AssociateAddressCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<AssociateAddressCommandInput, AssociateAddressCommandOutput>;
    private serialize;
    private deserialize;
}
