import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { AssignIpv6AddressesRequest, AssignIpv6AddressesResult } from "../models/models_0";
export interface AssignIpv6AddressesCommandInput extends AssignIpv6AddressesRequest {
}
export interface AssignIpv6AddressesCommandOutput extends AssignIpv6AddressesResult, __MetadataBearer {
}

export declare class AssignIpv6AddressesCommand extends $Command<AssignIpv6AddressesCommandInput, AssignIpv6AddressesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: AssignIpv6AddressesCommandInput;
    constructor(input: AssignIpv6AddressesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<AssignIpv6AddressesCommandInput, AssignIpv6AddressesCommandOutput>;
    private serialize;
    private deserialize;
}
