import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { AllocateAddressRequest, AllocateAddressResult } from "../models/models_0";
export interface AllocateAddressCommandInput extends AllocateAddressRequest {
}
export interface AllocateAddressCommandOutput extends AllocateAddressResult, __MetadataBearer {
}

export declare class AllocateAddressCommand extends $Command<AllocateAddressCommandInput, AllocateAddressCommandOutput, EC2ClientResolvedConfig> {
    readonly input: AllocateAddressCommandInput;
    constructor(input: AllocateAddressCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<AllocateAddressCommandInput, AllocateAddressCommandOutput>;
    private serialize;
    private deserialize;
}
