import { _InstanceType, AccessScopeAnalysisFinding, AddIpamOperatingRegion, AddPrefixListEntry, AddressAttribute, AddressAttributeName, Affinity, ApplianceModeSupportValue, AttributeValue, AutoPlacement, ByoipCidr, ClientConnectOptions, ClientVpnAuthorizationRuleStatus, ConnectionLogOptions, CurrencyCodeValues, DnsSupportValue, EndDateType, FleetExcessCapacityTerminationPolicy, HostnameType, HostRecovery, IamInstanceProfileAssociation, IamInstanceProfileSpecification, InstanceEventWindow, IpPermission, Ipv6SupportValue, PortRange, RouteTableAssociationState, SelfServicePortal, SubnetAssociation, Tag, TagSpecification, TargetConfigurationRequest, TransitGatewayAssociationState, TransitGatewayAttachmentResourceType, TransitGatewayMulticastDomainAssociations, TransitGatewayPeeringAttachment, TransitGatewayVpcAttachment, UnsuccessfulItem } from "./models_0";
import { AutoAcceptSharedAttachmentsValue, BlockDeviceMapping, CapacityReservationPreference, CapacityReservationTarget, DefaultRouteTableAssociationValue, DefaultRouteTablePropagationValue, DiskImageFormat, FleetLaunchTemplateConfigRequest, IcmpTypeCode, InstanceEventWindowTimeRangeRequest, InstanceInterruptionBehavior, InstanceRequirementsRequest, Ipam, IpamPool, IpamScope, LaunchTemplate, ManagedPrefixList, MarketType, NetworkInsightsAccessScopeContent, Placement, PlatformValues, RequestIpamResourceTag, ResponseLaunchTemplateData, RuleAction, ShutdownBehavior, SnapshotState, SpotInstanceType, SubnetCidrReservation, TargetCapacitySpecificationRequest, TargetCapacityUnitType, TrafficDirection, TrafficMirrorFilter, TrafficMirrorFilterRule, TrafficMirrorNetworkService, TrafficMirrorPortRangeRequest, TrafficMirrorRuleAction, TrafficMirrorSession, TransitGateway, VolumeType, VpnEcmpSupportValue } from "./models_1";
import { Filter, IKEVersionsRequestListValue, InstanceTagNotificationAttribute, IpamPoolCidr, Phase1DHGroupNumbersRequestListValue, Phase1EncryptionAlgorithmsRequestListValue, Phase1IntegrityAlgorithmsRequestListValue, Phase2DHGroupNumbersRequestListValue, Phase2EncryptionAlgorithmsRequestListValue, Phase2IntegrityAlgorithmsRequestListValue, TransitGatewayPrefixListReference, TransitGatewayRoute, VpnConnection } from "./models_2";
import { AnalysisStatus, ArchitectureType, ArchitectureValues, AttributeBooleanValue, BootModeValues, ConversionTask, FpgaImageAttribute, FpgaImageAttributeName, HttpTokensState, ImportImageLicenseConfigurationResponse, InstanceAttributeName, InstanceMetadataEndpointState, InstanceMetadataOptionsResponse, InstanceMetadataProtocolState, InstanceStatusEvent, LaunchPermission, Monitoring, PermissionGroup, PublicIpv4PoolRange, ReservedInstancesConfiguration, SnapshotDetail, SnapshotTaskDetail, VirtualizationType } from "./models_3";
import { CreateVolumePermission, ExcessCapacityTerminationPolicy, InstanceFamilyCreditSpecification, InstanceNetworkInterfaceSpecification, IpamResourceCidr, LaunchTemplateConfig, Purchase, RunInstancesMonitoringEnabled, ScheduledInstance, SnapshotAttributeName, SpotFleetRequestConfigData, SpotInstanceRequest, SpotPlacement, TransitGatewayPropagationState, UnlimitedSupportedInstanceFamily, VolumeModification } from "./models_4";
export interface GetLaunchTemplateDataResult {
    /**
     * <p>The instance data.</p>
     */
    LaunchTemplateData?: ResponseLaunchTemplateData;
}
export declare namespace GetLaunchTemplateDataResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetLaunchTemplateDataResult) => any;
}
export interface GetManagedPrefixListAssociationsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the prefix list.</p>
     */
    PrefixListId: string | undefined;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace GetManagedPrefixListAssociationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetManagedPrefixListAssociationsRequest) => any;
}
/**
 * <p>Describes the resource with which a prefix list is associated.</p>
 */
export interface PrefixListAssociation {
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The owner of the resource.</p>
     */
    ResourceOwner?: string;
}
export declare namespace PrefixListAssociation {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PrefixListAssociation) => any;
}
export interface GetManagedPrefixListAssociationsResult {
    /**
     * <p>Information about the associations.</p>
     */
    PrefixListAssociations?: PrefixListAssociation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetManagedPrefixListAssociationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetManagedPrefixListAssociationsResult) => any;
}
export interface GetManagedPrefixListEntriesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the prefix list.</p>
     */
    PrefixListId: string | undefined;
    /**
     * <p>The version of the prefix list for which to return the entries. The default is the current version.</p>
     */
    TargetVersion?: number;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace GetManagedPrefixListEntriesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetManagedPrefixListEntriesRequest) => any;
}
/**
 * <p>Describes a prefix list entry.</p>
 */
export interface PrefixListEntry {
    /**
     * <p>The CIDR block.</p>
     */
    Cidr?: string;
    /**
     * <p>The description.</p>
     */
    Description?: string;
}
export declare namespace PrefixListEntry {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PrefixListEntry) => any;
}
export interface GetManagedPrefixListEntriesResult {
    /**
     * <p>Information about the prefix list entries.</p>
     */
    Entries?: PrefixListEntry[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetManagedPrefixListEntriesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetManagedPrefixListEntriesResult) => any;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsRequest {
    /**
     * <p>The ID of the Network Access Scope analysis.</p>
     */
    NetworkInsightsAccessScopeAnalysisId: string | undefined;
    /**
     * <p>The maximum number of results to return with a single call.
     *    To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetNetworkInsightsAccessScopeAnalysisFindingsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetNetworkInsightsAccessScopeAnalysisFindingsRequest) => any;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsResult {
    /**
     * <p>The ID of the Network Access Scope analysis.</p>
     */
    NetworkInsightsAccessScopeAnalysisId?: string;
    /**
     * <p>The status of Network Access Scope Analysis.</p>
     */
    AnalysisStatus?: AnalysisStatus | string;
    /**
     * <p>The findings associated with Network Access Scope Analysis.</p>
     */
    AnalysisFindings?: AccessScopeAnalysisFinding[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetNetworkInsightsAccessScopeAnalysisFindingsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetNetworkInsightsAccessScopeAnalysisFindingsResult) => any;
}
export interface GetNetworkInsightsAccessScopeContentRequest {
    /**
     * <p>The ID of the Network Access Scope.</p>
     */
    NetworkInsightsAccessScopeId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetNetworkInsightsAccessScopeContentRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetNetworkInsightsAccessScopeContentRequest) => any;
}
export interface GetNetworkInsightsAccessScopeContentResult {
    /**
     * <p>The Network Access Scope content.</p>
     */
    NetworkInsightsAccessScopeContent?: NetworkInsightsAccessScopeContent;
}
export declare namespace GetNetworkInsightsAccessScopeContentResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetNetworkInsightsAccessScopeContentResult) => any;
}
export interface GetPasswordDataRequest {
    /**
     * <p>The ID of the Windows instance.</p>
     */
    InstanceId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetPasswordDataRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetPasswordDataRequest) => any;
}
export interface GetPasswordDataResult {
    /**
     * <p>The ID of the Windows instance.</p>
     */
    InstanceId?: string;
    /**
     * <p>The password of the instance. Returns an empty string if the password is not
     *             available.</p>
     */
    PasswordData?: string;
    /**
     * <p>The time the data was last updated.</p>
     */
    Timestamp?: Date;
}
export declare namespace GetPasswordDataResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetPasswordDataResult) => any;
}
/**
 * <p>Contains the parameters for GetReservedInstanceExchangeQuote.</p>
 */
export interface GetReservedInstancesExchangeQuoteRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *       and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *       Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the Convertible Reserved Instances to exchange.</p>
     */
    ReservedInstanceIds: string[] | undefined;
    /**
     * <p>The configuration of the target Convertible Reserved Instance to exchange for your
     *             current Convertible Reserved Instances.</p>
     */
    TargetConfigurations?: TargetConfigurationRequest[];
}
export declare namespace GetReservedInstancesExchangeQuoteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetReservedInstancesExchangeQuoteRequest) => any;
}
/**
 * <p>The cost associated with the Reserved Instance.</p>
 */
export interface ReservationValue {
    /**
     * <p>The hourly rate of the reservation.</p>
     */
    HourlyPrice?: string;
    /**
     * <p>The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours remaining).</p>
     */
    RemainingTotalValue?: string;
    /**
     * <p>The remaining upfront cost of the reservation.</p>
     */
    RemainingUpfrontValue?: string;
}
export declare namespace ReservationValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReservationValue) => any;
}
/**
 * <p>The total value of the Convertible Reserved Instance.</p>
 */
export interface ReservedInstanceReservationValue {
    /**
     * <p>The total value of the Convertible Reserved Instance that you are exchanging.</p>
     */
    ReservationValue?: ReservationValue;
    /**
     * <p>The ID of the Convertible Reserved Instance that you are exchanging.</p>
     */
    ReservedInstanceId?: string;
}
export declare namespace ReservedInstanceReservationValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReservedInstanceReservationValue) => any;
}
/**
 * <p>Information about the Convertible Reserved Instance offering.</p>
 */
export interface TargetConfiguration {
    /**
     * <p>The number of instances the Convertible Reserved Instance offering can be applied to. This parameter is
     *       reserved and cannot be specified in a request</p>
     */
    InstanceCount?: number;
    /**
     * <p>The ID of the Convertible Reserved Instance offering.</p>
     */
    OfferingId?: string;
}
export declare namespace TargetConfiguration {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TargetConfiguration) => any;
}
/**
 * <p>The total value of the new Convertible Reserved Instances.</p>
 */
export interface TargetReservationValue {
    /**
     * <p>The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of
     *       the list value, remaining upfront price, and additional upfront cost of the exchange.</p>
     */
    ReservationValue?: ReservationValue;
    /**
     * <p>The configuration of the Convertible Reserved Instances that make up the exchange.</p>
     */
    TargetConfiguration?: TargetConfiguration;
}
export declare namespace TargetReservationValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TargetReservationValue) => any;
}
/**
 * <p>Contains the output of GetReservedInstancesExchangeQuote.</p>
 */
export interface GetReservedInstancesExchangeQuoteResult {
    /**
     * <p>The currency of the transaction.</p>
     */
    CurrencyCode?: string;
    /**
     * <p>If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.</p>
     */
    IsValidExchange?: boolean;
    /**
     * <p>The new end date of the reservation term.</p>
     */
    OutputReservedInstancesWillExpireAt?: Date;
    /**
     * <p>The total true upfront charge for the exchange.</p>
     */
    PaymentDue?: string;
    /**
     * <p>The cost associated with the Reserved Instance.</p>
     */
    ReservedInstanceValueRollup?: ReservationValue;
    /**
     * <p>The configuration of your Convertible Reserved Instances.</p>
     */
    ReservedInstanceValueSet?: ReservedInstanceReservationValue[];
    /**
     * <p>The cost associated with the Reserved Instance.</p>
     */
    TargetConfigurationValueRollup?: ReservationValue;
    /**
     * <p>The values of the target Convertible Reserved Instances.</p>
     */
    TargetConfigurationValueSet?: TargetReservationValue[];
    /**
     * <p>Describes the reason why the exchange cannot be completed.</p>
     */
    ValidationFailureReason?: string;
}
export declare namespace GetReservedInstancesExchangeQuoteResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetReservedInstancesExchangeQuoteResult) => any;
}
export interface GetSerialConsoleAccessStatusRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetSerialConsoleAccessStatusRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetSerialConsoleAccessStatusRequest) => any;
}
export interface GetSerialConsoleAccessStatusResult {
    /**
     * <p>If <code>true</code>, access to the EC2 serial console of all instances is enabled for
     * 			your account. If <code>false</code>, access to the EC2 serial console of all instances
     * 			is disabled for your account.</p>
     */
    SerialConsoleAccessEnabled?: boolean;
}
export declare namespace GetSerialConsoleAccessStatusResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetSerialConsoleAccessStatusResult) => any;
}
/**
 * <p>The architecture type, virtualization type, and other attributes for the instance types.
 *          When you specify instance attributes, Amazon EC2 will identify instance types with those
 *          attributes.</p>
 *          <p>If you specify <code>InstanceRequirementsWithMetadataRequest</code>, you can't specify
 *          <code>InstanceTypes</code>.</p>
 */
export interface InstanceRequirementsWithMetadataRequest {
    /**
     * <p>The architecture type.</p>
     */
    ArchitectureTypes?: (ArchitectureType | string)[];
    /**
     * <p>The virtualization type.</p>
     */
    VirtualizationTypes?: (VirtualizationType | string)[];
    /**
     * <p>The attributes for the instance types. When you specify instance attributes, Amazon EC2 will
     *          identify instance types with those attributes.</p>
     */
    InstanceRequirements?: InstanceRequirementsRequest;
}
export declare namespace InstanceRequirementsWithMetadataRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceRequirementsWithMetadataRequest) => any;
}
export interface GetSpotPlacementScoresRequest {
    /**
     * <p>The instance types. We recommend that you specify at least three instance types. If you
     *          specify one or two instance types, or specify variations of a single instance type (for
     *          example, an <code>m3.xlarge</code> with and without instance storage), the returned
     *          placement score will always be low. </p>
     *          <p>If you specify <code>InstanceTypes</code>, you can't specify
     *             <code>InstanceRequirementsWithMetadata</code>.</p>
     */
    InstanceTypes?: string[];
    /**
     * <p>The target capacity.</p>
     */
    TargetCapacity: number | undefined;
    /**
     * <p>The unit for the target capacity.</p>
     *          <p>Default: <code>units</code> (translates to number of instances)</p>
     */
    TargetCapacityUnitType?: TargetCapacityUnitType | string;
    /**
     * <p>Specify <code>true</code> so that the response returns a list of scored Availability Zones.
     *          Otherwise, the response returns a list of scored Regions.</p>
     *          <p>A list of scored Availability Zones is useful if you want to launch all of your Spot
     *          capacity into a single Availability Zone.</p>
     */
    SingleAvailabilityZone?: boolean;
    /**
     * <p>The Regions used to narrow down the list of Regions to be scored. Enter the Region code,
     *          for example, <code>us-east-1</code>.</p>
     */
    RegionNames?: string[];
    /**
     * <p>The attributes for the instance types. When you specify instance attributes, Amazon EC2 will
     *          identify instance types with those attributes.</p>
     *          <p>If you specify <code>InstanceRequirementsWithMetadata</code>, you can't specify
     *             <code>InstanceTypes</code>.</p>
     */
    InstanceRequirementsWithMetadata?: InstanceRequirementsWithMetadataRequest;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of results to return in a single call. Specify a value between 1 and
     *       1000. The default value is 1000. To retrieve the remaining results, make another call with
     *       the returned <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
}
export declare namespace GetSpotPlacementScoresRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetSpotPlacementScoresRequest) => any;
}
/**
 * <p>The Spot placement score for this Region or Availability Zone. The score is calculated
 *          based on the assumption that the <code>capacity-optimized</code> allocation strategy is
 *          used and that all of the Availability Zones in the Region can be used.</p>
 */
export interface SpotPlacementScore {
    /**
     * <p>The Region.</p>
     */
    Region?: string;
    /**
     * <p>The Availability Zone.</p>
     */
    AvailabilityZoneId?: string;
    /**
     * <p>The placement score, on a scale from <code>1</code> to <code>10</code>. A score of
     *             <code>10</code> indicates that your Spot request is highly likely to succeed in this
     *          Region or Availability Zone. A score of <code>1</code> indicates that your Spot request is
     *          not likely to succeed. </p>
     */
    Score?: number;
}
export declare namespace SpotPlacementScore {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotPlacementScore) => any;
}
export interface GetSpotPlacementScoresResult {
    /**
     * <p>The Spot placement score for the top 10 Regions or Availability Zones, scored on a scale
     *          from 1 to 10. Each score
   reflects how likely it is that each Region or Availability Zone
     *          will succeed at fulfilling the specified target capacity
   <i>at the time of the Spot
     *             placement score request</i>. A score of <code>10</code> means that your Spot
     *          capacity request is highly likely to succeed in that Region or Availability Zone. </p>
     *          <p>If you request a Spot placement score for Regions, a high score assumes that your fleet
     *          request will be configured to use all Availability Zones and the
     *             <code>capacity-optimized</code> allocation strategy. If you request a Spot placement
     *          score for Availability Zones, a high score assumes that your fleet request will be
     *          configured to use a single Availability Zone and the <code>capacity-optimized</code>
     *          allocation strategy.</p>
     *          <p>Different
   Regions or Availability Zones might return the same score.</p>
     *          <note>
     *             <p>The Spot placement score serves as a recommendation only. No score guarantees that your
     *             Spot request will be fully or partially fulfilled.</p>
     *          </note>
     */
    SpotPlacementScores?: SpotPlacementScore[];
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
}
export declare namespace GetSpotPlacementScoresResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetSpotPlacementScoresResult) => any;
}
export interface GetSubnetCidrReservationsRequest {
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                     <code>reservationType</code> - The type of reservation (<code>prefix</code> |
     *                     <code>explicit</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>subnet-id</code> - The ID of the subnet.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The ID of the subnet.</p>
     */
    SubnetId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
}
export declare namespace GetSubnetCidrReservationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetSubnetCidrReservationsRequest) => any;
}
export interface GetSubnetCidrReservationsResult {
    /**
     * <p>Information about the IPv4 subnet CIDR reservations.</p>
     */
    SubnetIpv4CidrReservations?: SubnetCidrReservation[];
    /**
     * <p>Information about the IPv6 subnet CIDR reservations.</p>
     */
    SubnetIpv6CidrReservations?: SubnetCidrReservation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetSubnetCidrReservationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetSubnetCidrReservationsResult) => any;
}
export interface GetTransitGatewayAttachmentPropagationsRequest {
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayAttachmentPropagationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayAttachmentPropagationsRequest) => any;
}
/**
 * <p>Describes a propagation route table.</p>
 */
export interface TransitGatewayAttachmentPropagation {
    /**
     * <p>The ID of the propagation route table.</p>
     */
    TransitGatewayRouteTableId?: string;
    /**
     * <p>The state of the propagation route table.</p>
     */
    State?: TransitGatewayPropagationState | string;
}
export declare namespace TransitGatewayAttachmentPropagation {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayAttachmentPropagation) => any;
}
export interface GetTransitGatewayAttachmentPropagationsResult {
    /**
     * <p>Information about the propagation route tables.</p>
     */
    TransitGatewayAttachmentPropagations?: TransitGatewayAttachmentPropagation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetTransitGatewayAttachmentPropagationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayAttachmentPropagationsResult) => any;
}
export interface GetTransitGatewayMulticastDomainAssociationsRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>One or more filters. The possible values are:</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>resource-id</code> - The ID of the resource.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>resource-type</code> - The type of resource. The valid value is: <code>vpc</code>.</p>
     *             </li>
     *             <li>
     *
     *                 <p>
     *                   <code>state</code> - The state of the subnet association. Valid values are
     *                         <code>associated</code> |
     *                         <code>associating</code>
     *                     | <code>disassociated</code> | <code>disassociating</code>.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>subnet-id</code> - The ID of the subnet.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>transit-gateway-attachment-id</code> - The id of the transit gateway attachment.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayMulticastDomainAssociationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayMulticastDomainAssociationsRequest) => any;
}
/**
 * <p>Describes the resources associated with the transit gateway multicast domain.</p>
 */
export interface TransitGatewayMulticastDomainAssociation {
    /**
     * <p>The ID of the transit gateway attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The type of resource, for example a VPC attachment.</p>
     */
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    /**
     * <p> The ID of the Amazon Web Services account that owns the transit gateway multicast domain association resource.</p>
     */
    ResourceOwnerId?: string;
    /**
     * <p>The subnet associated with the transit gateway multicast domain.</p>
     */
    Subnet?: SubnetAssociation;
}
export declare namespace TransitGatewayMulticastDomainAssociation {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayMulticastDomainAssociation) => any;
}
export interface GetTransitGatewayMulticastDomainAssociationsResult {
    /**
     * <p>Information about the multicast domain associations.</p>
     */
    MulticastDomainAssociations?: TransitGatewayMulticastDomainAssociation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetTransitGatewayMulticastDomainAssociationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayMulticastDomainAssociationsResult) => any;
}
export interface GetTransitGatewayPrefixListReferencesRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>One or more filters. The possible values are:</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>attachment.resource-id</code> - The ID of the resource for the attachment.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>attachment.resource-type</code> - The type of resource for the
     *                     attachment. Valid values are <code>vpc</code> | <code>vpn</code> |
     *                         <code>direct-connect-gateway</code> | <code>peering</code>.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>attachment.transit-gateway-attachment-id</code> - The ID of the attachment.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>is-blackhole</code> - Whether traffic matching the route is blocked (<code>true</code> | <code>false</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>prefix-list-id</code> - The ID of the prefix list.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>prefix-list-owner-id</code> - The ID of the owner of the prefix list.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>state</code> - The state of the prefix list reference (<code>pending</code> | <code>available</code> | <code>modifying</code> | <code>deleting</code>).</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayPrefixListReferencesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayPrefixListReferencesRequest) => any;
}
export interface GetTransitGatewayPrefixListReferencesResult {
    /**
     * <p>Information about the prefix list references.</p>
     */
    TransitGatewayPrefixListReferences?: TransitGatewayPrefixListReference[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetTransitGatewayPrefixListReferencesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayPrefixListReferencesResult) => any;
}
export interface GetTransitGatewayRouteTableAssociationsRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>resource-id</code> - The ID of the resource.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-type</code> - The resource type. Valid values are <code>vpc</code>
     *                     | <code>vpn</code> | <code>direct-connect-gateway</code> | <code>peering</code>
     *                     | <code>connect</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayRouteTableAssociationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayRouteTableAssociationsRequest) => any;
}
/**
 * <p>Describes an association between a route table and a resource attachment.</p>
 */
export interface TransitGatewayRouteTableAssociation {
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.</p>
     */
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    /**
     * <p>The state of the association.</p>
     */
    State?: TransitGatewayAssociationState | string;
}
export declare namespace TransitGatewayRouteTableAssociation {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayRouteTableAssociation) => any;
}
export interface GetTransitGatewayRouteTableAssociationsResult {
    /**
     * <p>Information about the associations.</p>
     */
    Associations?: TransitGatewayRouteTableAssociation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetTransitGatewayRouteTableAssociationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayRouteTableAssociationsResult) => any;
}
export interface GetTransitGatewayRouteTablePropagationsRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>resource-id</code> - The ID of the resource.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-type</code> - The resource type. Valid values are <code>vpc</code>
     *                     | <code>vpn</code> | <code>direct-connect-gateway</code> | <code>peering</code>
     *                     | <code>connect</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayRouteTablePropagationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayRouteTablePropagationsRequest) => any;
}
/**
 * <p>Describes a route table propagation.</p>
 */
export interface TransitGatewayRouteTablePropagation {
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The type of resource. Note that the <code>tgw-peering</code> resource type has been deprecated.</p>
     */
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    /**
     * <p>The state of the resource.</p>
     */
    State?: TransitGatewayPropagationState | string;
}
export declare namespace TransitGatewayRouteTablePropagation {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayRouteTablePropagation) => any;
}
export interface GetTransitGatewayRouteTablePropagationsResult {
    /**
     * <p>Information about the route table propagations.</p>
     */
    TransitGatewayRouteTablePropagations?: TransitGatewayRouteTablePropagation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetTransitGatewayRouteTablePropagationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetTransitGatewayRouteTablePropagationsResult) => any;
}
export interface GetVpnConnectionDeviceSampleConfigurationRequest {
    /**
     * <p>The <code>VpnConnectionId</code> specifies the Site-to-Site VPN connection used for the sample
     *             configuration.</p>
     */
    VpnConnectionId: string | undefined;
    /**
     * <p>Device identifier provided by the <code>GetVpnConnectionDeviceTypes</code> API.</p>
     */
    VpnConnectionDeviceTypeId: string | undefined;
    /**
     * <p>The IKE version to be used in the sample configuration file for your customer gateway
     *             device. You can specify one of the following versions: <code>ikev1</code> or
     *                 <code>ikev2</code>.</p>
     */
    InternetKeyExchangeVersion?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetVpnConnectionDeviceSampleConfigurationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetVpnConnectionDeviceSampleConfigurationRequest) => any;
}
export interface GetVpnConnectionDeviceSampleConfigurationResult {
    /**
     * <p>Sample configuration file for the specified customer gateway device.</p>
     */
    VpnConnectionDeviceSampleConfiguration?: string;
}
export declare namespace GetVpnConnectionDeviceSampleConfigurationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetVpnConnectionDeviceSampleConfigurationResult) => any;
}
export interface GetVpnConnectionDeviceTypesRequest {
    /**
     * <p>The maximum number of results returned by <code>GetVpnConnectionDeviceTypes</code> in
     *             paginated output. When this parameter is used, <code>GetVpnConnectionDeviceTypes</code>
     *             only returns <code>MaxResults</code> results in a single page along with a
     *                 <code>NextToken</code> response element. The remaining results of the initial
     *             request can be seen by sending another <code>GetVpnConnectionDeviceTypes</code> request
     *             with the returned <code>NextToken</code> value. This value can be between 200 and 1000.
     *             If this parameter is not used, then <code>GetVpnConnectionDeviceTypes</code> returns all
     *             results.</p>
     */
    MaxResults?: number;
    /**
     * <p>The <code>NextToken</code> value returned from a previous paginated
     *                 <code>GetVpnConnectionDeviceTypes</code> request where <code>MaxResults</code> was
     *             used and the results exceeded the value of that parameter. Pagination continues from the
     *             end of the previous results that returned the <code>NextToken</code> value. This value
     *             is null when there are no more results to return. </p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetVpnConnectionDeviceTypesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetVpnConnectionDeviceTypesRequest) => any;
}
/**
 * <p>List of customer gateway devices that have a sample configuration file available for
 *             use. You can also see the list of device types with sample configuration files available
 *             under <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/your-cgw.html">Your customer
 *                 gateway device</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>
 */
export interface VpnConnectionDeviceType {
    /**
     * <p>Customer gateway device identifier.</p>
     */
    VpnConnectionDeviceTypeId?: string;
    /**
     * <p>Customer gateway device vendor.</p>
     */
    Vendor?: string;
    /**
     * <p>Customer gateway device platform.</p>
     */
    Platform?: string;
    /**
     * <p>Customer gateway device software version.</p>
     */
    Software?: string;
}
export declare namespace VpnConnectionDeviceType {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpnConnectionDeviceType) => any;
}
export interface GetVpnConnectionDeviceTypesResult {
    /**
     * <p>List of customer gateway devices that have a sample configuration file available for
     *             use.</p>
     */
    VpnConnectionDeviceTypes?: VpnConnectionDeviceType[];
    /**
     * <p>The <code>NextToken</code> value to include in a future
     *                 <code>GetVpnConnectionDeviceTypes</code> request. When the results of a
     *                 <code>GetVpnConnectionDeviceTypes</code> request exceed <code>MaxResults</code>,
     *             this value can be used to retrieve the next page of results. This value is null when
     *             there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetVpnConnectionDeviceTypesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetVpnConnectionDeviceTypesResult) => any;
}
export interface ImportClientVpnClientCertificateRevocationListRequest {
    /**
     * <p>The ID of the Client VPN endpoint to which the client certificate revocation list applies.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>The client certificate revocation list file. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/cvpn-working-certificates.html#cvpn-working-certificates-generate">Generate a Client Certificate Revocation List</a> in the
     * 				<i>Client VPN Administrator Guide</i>.</p>
     */
    CertificateRevocationList: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ImportClientVpnClientCertificateRevocationListRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportClientVpnClientCertificateRevocationListRequest) => any;
}
export interface ImportClientVpnClientCertificateRevocationListResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace ImportClientVpnClientCertificateRevocationListResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportClientVpnClientCertificateRevocationListResult) => any;
}
/**
 * <p>Describes the client-specific data.</p>
 */
export interface ClientData {
    /**
     * <p>A user-defined comment about the disk upload.</p>
     */
    Comment?: string;
    /**
     * <p>The time that the disk upload ends.</p>
     */
    UploadEnd?: Date;
    /**
     * <p>The size of the uploaded disk image, in GiB.</p>
     */
    UploadSize?: number;
    /**
     * <p>The time that the disk upload starts.</p>
     */
    UploadStart?: Date;
}
export declare namespace ClientData {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClientData) => any;
}
/**
 * <p>Describes the Amazon S3 bucket for the disk image.</p>
 */
export interface UserBucket {
    /**
     * <p>The name of the Amazon S3 bucket where the disk image is located.</p>
     */
    S3Bucket?: string;
    /**
     * <p>The file name of the disk image.</p>
     */
    S3Key?: string;
}
export declare namespace UserBucket {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: UserBucket) => any;
}
/**
 * <p>Describes the disk container object for an import image task.</p>
 */
export interface ImageDiskContainer {
    /**
     * <p>The description of the disk image.</p>
     */
    Description?: string;
    /**
     * <p>The block device mapping for the disk.</p>
     */
    DeviceName?: string;
    /**
     * <p>The format of the disk image being imported.</p>
     *          <p>Valid values: <code>OVA</code> | <code>VHD</code> | <code>VHDX</code> | <code>VMDK</code> | <code>RAW</code>
     *          </p>
     */
    Format?: string;
    /**
     * <p>The ID of the EBS snapshot to be used for importing the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or an
     *    Amazon S3 URL (s3://..)</p>
     */
    Url?: string;
    /**
     * <p>The S3 bucket for the disk image.</p>
     */
    UserBucket?: UserBucket;
}
export declare namespace ImageDiskContainer {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImageDiskContainer) => any;
}
/**
 * <p>The request information of license configurations.</p>
 */
export interface ImportImageLicenseConfigurationRequest {
    /**
     * <p>The ARN of a license configuration.</p>
     */
    LicenseConfigurationArn?: string;
}
export declare namespace ImportImageLicenseConfigurationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportImageLicenseConfigurationRequest) => any;
}
export interface ImportImageRequest {
    /**
     * <p>The architecture of the virtual machine.</p>
     *          <p>Valid values: <code>i386</code> | <code>x86_64</code> | <code>arm64</code>
     *          </p>
     */
    Architecture?: string;
    /**
     * <p>The client-specific data.</p>
     */
    ClientData?: ClientData;
    /**
     * <p>The token to enable idempotency for VM import requests.</p>
     */
    ClientToken?: string;
    /**
     * <p>A description string for the import image task.</p>
     */
    Description?: string;
    /**
     * <p>Information about the disk containers.</p>
     */
    DiskContainers?: ImageDiskContainer[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for EBS is used
     *    unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     *     <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     */
    Encrypted?: boolean;
    /**
     * <p>The target hypervisor platform.</p>
     *          <p>Valid values: <code>xen</code>
     *          </p>
     */
    Hypervisor?: string;
    /**
     * <p>An identifier for the symmetric KMS key to use when creating the
     *    encrypted AMI. This parameter is only required if you want to use a non-default KMS key; if this
     *    parameter is not specified, the default KMS key for EBS is used. If a <code>KmsKeyId</code> is
     *    specified, the <code>Encrypted</code> flag must also be set. </p>
     *          <p>The KMS key identifier may be provided in any of the following formats: </p>
     *          <ul>
     *             <li>
     *                <p>Key ID</p>
     *             </li>
     *             <li>
     *                <p>Key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the key alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.</p>
     *             </li>
     *             <li>
     *                <p>ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and then the key ID. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.</p>
     *             </li>
     *             <li>
     *                <p>ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the key alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>. </p>
     *             </li>
     *          </ul>
     *          <p>Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may appear to complete even
     *    though you provided an invalid identifier. This action will eventually report failure. </p>
     *          <p>The specified KMS key must exist in the Region that the AMI is being copied to.</p>
     *          <p>Amazon EBS does not support asymmetric KMS keys.</p>
     */
    KmsKeyId?: string;
    /**
     * <p>The license type to be used for the Amazon Machine Image (AMI) after importing.</p>
     *          <p>By default, we detect the source-system operating system (OS) and apply the appropriate license. Specify
     *    <code>AWS</code> to replace the source-system license with an Amazon Web Services license, if appropriate. Specify <code>BYOL</code>
     *    to retain the source-system license, if appropriate.</p>
     *          <p>To use <code>BYOL</code>, you must have existing licenses with rights to use these licenses in a third party
     *    cloud, such as Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image">Prerequisites</a> in the
     *    VM Import/Export User Guide.</p>
     */
    LicenseType?: string;
    /**
     * <p>The operating system of the virtual machine.</p>
     *          <p>Valid values: <code>Windows</code> | <code>Linux</code>
     *          </p>
     */
    Platform?: string;
    /**
     * <p>The name of the role to use when not using the default role, 'vmimport'.</p>
     */
    RoleName?: string;
    /**
     * <p>The ARNs of the license configurations.</p>
     */
    LicenseSpecifications?: ImportImageLicenseConfigurationRequest[];
    /**
     * <p>The tags to apply to the import image task during creation.</p>
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>The usage operation value. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites">Licensing options</a> in the <i>VM Import/Export User Guide</i>.</p>
     */
    UsageOperation?: string;
    /**
     * <p>The boot mode of the virtual machine.</p>
     */
    BootMode?: BootModeValues | string;
}
export declare namespace ImportImageRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportImageRequest) => any;
}
export interface ImportImageResult {
    /**
     * <p>The architecture of the virtual machine.</p>
     */
    Architecture?: string;
    /**
     * <p>A description of the import task.</p>
     */
    Description?: string;
    /**
     * <p>Indicates whether the AMI is encrypted.</p>
     */
    Encrypted?: boolean;
    /**
     * <p>The target hypervisor of the import task.</p>
     */
    Hypervisor?: string;
    /**
     * <p>The ID of the Amazon Machine Image (AMI) created by the import task.</p>
     */
    ImageId?: string;
    /**
     * <p>The task ID of the import image task.</p>
     */
    ImportTaskId?: string;
    /**
     * <p>The identifier for the symmetric KMS key that was used to create the encrypted AMI.</p>
     */
    KmsKeyId?: string;
    /**
     * <p>The license type of the virtual machine.</p>
     */
    LicenseType?: string;
    /**
     * <p>The operating system of the virtual machine.</p>
     */
    Platform?: string;
    /**
     * <p>The progress of the task.</p>
     */
    Progress?: string;
    /**
     * <p>Information about the snapshots.</p>
     */
    SnapshotDetails?: SnapshotDetail[];
    /**
     * <p>A brief status of the task.</p>
     */
    Status?: string;
    /**
     * <p>A detailed status message of the import task.</p>
     */
    StatusMessage?: string;
    /**
     * <p>The ARNs of the license configurations.</p>
     */
    LicenseSpecifications?: ImportImageLicenseConfigurationResponse[];
    /**
     * <p>Any tags assigned to the import image task.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The usage operation value.</p>
     */
    UsageOperation?: string;
}
export declare namespace ImportImageResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportImageResult) => any;
}
/**
 * <p>Describes a disk image.</p>
 */
export interface DiskImageDetail {
    /**
     * <p>The size of the disk image, in GiB.</p>
     */
    Bytes: number | undefined;
    /**
     * <p>The disk image format.</p>
     */
    Format: DiskImageFormat | string | undefined;
    /**
     * <p>A presigned URL for the import manifest stored in Amazon S3 and presented here as an Amazon S3 presigned URL.
     *    For information about creating a presigned URL for an Amazon S3 object, read the "Query String Request Authentication
     *    Alternative" section of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests</a> topic in the <i>Amazon Simple Storage Service Developer
     *     Guide</i>.</p>
     *          <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>
     */
    ImportManifestUrl: string | undefined;
}
export declare namespace DiskImageDetail {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DiskImageDetail) => any;
}
/**
 * <p>Describes an EBS volume.</p>
 */
export interface VolumeDetail {
    /**
     * <p>The size of the volume, in GiB.</p>
     */
    Size: number | undefined;
}
export declare namespace VolumeDetail {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VolumeDetail) => any;
}
/**
 * <p>Describes a disk image.</p>
 */
export interface DiskImage {
    /**
     * <p>A description of the disk image.</p>
     */
    Description?: string;
    /**
     * <p>Information about the disk image.</p>
     */
    Image?: DiskImageDetail;
    /**
     * <p>Information about the volume.</p>
     */
    Volume?: VolumeDetail;
}
export declare namespace DiskImage {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DiskImage) => any;
}
/**
 * <p>Describes the user data for an instance.</p>
 */
export interface UserData {
    /**
     * <p>The user data. If you are using an Amazon Web Services SDK or command line tool, Base64-encoding is performed for you, and you
     *    can load the text from a file. Otherwise, you must provide Base64-encoded text.</p>
     */
    Data?: string;
}
export declare namespace UserData {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: UserData) => any;
}
/**
 * <p>Describes the launch specification for VM import.</p>
 */
export interface ImportInstanceLaunchSpecification {
    /**
     * <p>Reserved.</p>
     */
    AdditionalInfo?: string;
    /**
     * <p>The architecture of the instance.</p>
     */
    Architecture?: ArchitectureValues | string;
    /**
     * <p>The security group IDs.</p>
     */
    GroupIds?: string[];
    /**
     * <p>The security group names.</p>
     */
    GroupNames?: string[];
    /**
     * <p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *    operating system command for system shutdown).</p>
     */
    InstanceInitiatedShutdownBehavior?: ShutdownBehavior | string;
    /**
     * <p>The instance type. For more information about the instance types that you can import, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-instance-types">Instance Types</a> in the
     *    VM Import/Export User Guide.</p>
     */
    InstanceType?: _InstanceType | string;
    /**
     * <p>Indicates whether monitoring is enabled.</p>
     */
    Monitoring?: boolean;
    /**
     * <p>The placement information for the instance.</p>
     */
    Placement?: Placement;
    /**
     * <p>[EC2-VPC] An available IP address from the IP address range of the subnet.</p>
     */
    PrivateIpAddress?: string;
    /**
     * <p>[EC2-VPC] The ID of the subnet in which to launch the instance.</p>
     */
    SubnetId?: string;
    /**
     * <p>The Base64-encoded user data to make available to the instance.</p>
     */
    UserData?: UserData;
}
export declare namespace ImportInstanceLaunchSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportInstanceLaunchSpecification) => any;
}
export interface ImportInstanceRequest {
    /**
     * <p>A description for the instance being imported.</p>
     */
    Description?: string;
    /**
     * <p>The disk image.</p>
     */
    DiskImages?: DiskImage[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The launch specification.</p>
     */
    LaunchSpecification?: ImportInstanceLaunchSpecification;
    /**
     * <p>The instance operating system.</p>
     */
    Platform: PlatformValues | string | undefined;
}
export declare namespace ImportInstanceRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportInstanceRequest) => any;
}
export interface ImportInstanceResult {
    /**
     * <p>Information about the conversion task.</p>
     */
    ConversionTask?: ConversionTask;
}
export declare namespace ImportInstanceResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportInstanceResult) => any;
}
export interface ImportKeyPairRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>A unique name for the key pair.</p>
     */
    KeyName: string | undefined;
    /**
     * <p>The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.</p>
     */
    PublicKeyMaterial: Uint8Array | undefined;
    /**
     * <p>The tags to apply to the imported key pair.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace ImportKeyPairRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportKeyPairRequest) => any;
}
export interface ImportKeyPairResult {
    /**
     * <p>The MD5 public key fingerprint as specified in section 4 of RFC 4716.</p>
     */
    KeyFingerprint?: string;
    /**
     * <p>The key pair name that you provided.</p>
     */
    KeyName?: string;
    /**
     * <p>The ID of the resulting key pair.</p>
     */
    KeyPairId?: string;
    /**
     * <p>The tags applied to the imported key pair.</p>
     */
    Tags?: Tag[];
}
export declare namespace ImportKeyPairResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportKeyPairResult) => any;
}
/**
 * <p>The disk container object for the import snapshot request.</p>
 */
export interface SnapshotDiskContainer {
    /**
     * <p>The description of the disk image being imported.</p>
     */
    Description?: string;
    /**
     * <p>The format of the disk image being imported.</p>
     *          <p>Valid values: <code>VHD</code> | <code>VMDK</code> | <code>RAW</code>
     *          </p>
     */
    Format?: string;
    /**
     * <p>The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or an Amazon
     *    S3 URL (s3://..).</p>
     */
    Url?: string;
    /**
     * <p>The Amazon S3 bucket for the disk image.</p>
     */
    UserBucket?: UserBucket;
}
export declare namespace SnapshotDiskContainer {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SnapshotDiskContainer) => any;
}
export interface ImportSnapshotRequest {
    /**
     * <p>The client-specific data.</p>
     */
    ClientData?: ClientData;
    /**
     * <p>Token to enable idempotency for VM import requests.</p>
     */
    ClientToken?: string;
    /**
     * <p>The description string for the import snapshot task.</p>
     */
    Description?: string;
    /**
     * <p>Information about the disk container.</p>
     */
    DiskContainer?: SnapshotDiskContainer;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is
     *    used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     *     <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     */
    Encrypted?: boolean;
    /**
     * <p>An identifier for the symmetric KMS key to use when creating the
     *    encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this
     *    parameter is not specified, the default KMS key for EBS is used. If a <code>KmsKeyId</code> is
     *    specified, the <code>Encrypted</code> flag must also be set. </p>
     *          <p>The KMS key identifier may be provided in any of the following formats: </p>
     *          <ul>
     *             <li>
     *                <p>Key ID</p>
     *             </li>
     *             <li>
     *                <p>Key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the key alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.</p>
     *             </li>
     *             <li>
     *                <p>ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and then the key ID. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.</p>
     *             </li>
     *             <li>
     *                <p>ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the key alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>. </p>
     *             </li>
     *          </ul>
     *          <p>Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may appear to complete even
     *    though you provided an invalid identifier. This action will eventually report failure. </p>
     *          <p>The specified KMS key must exist in the Region that the snapshot is being copied to.</p>
     *          <p>Amazon EBS does not support asymmetric KMS keys.</p>
     */
    KmsKeyId?: string;
    /**
     * <p>The name of the role to use when not using the default role, 'vmimport'.</p>
     */
    RoleName?: string;
    /**
     * <p>The tags to apply to the import snapshot task during creation.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace ImportSnapshotRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportSnapshotRequest) => any;
}
export interface ImportSnapshotResult {
    /**
     * <p>A description of the import snapshot task.</p>
     */
    Description?: string;
    /**
     * <p>The ID of the import snapshot task.</p>
     */
    ImportTaskId?: string;
    /**
     * <p>Information about the import snapshot task.</p>
     */
    SnapshotTaskDetail?: SnapshotTaskDetail;
    /**
     * <p>Any tags assigned to the import snapshot task.</p>
     */
    Tags?: Tag[];
}
export declare namespace ImportSnapshotResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportSnapshotResult) => any;
}
export interface ImportVolumeRequest {
    /**
     * <p>The Availability Zone for the resulting EBS volume.</p>
     */
    AvailabilityZone: string | undefined;
    /**
     * <p>A description of the volume.</p>
     */
    Description?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The disk image.</p>
     */
    Image: DiskImageDetail | undefined;
    /**
     * <p>The volume size.</p>
     */
    Volume: VolumeDetail | undefined;
}
export declare namespace ImportVolumeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportVolumeRequest) => any;
}
export interface ImportVolumeResult {
    /**
     * <p>Information about the conversion task.</p>
     */
    ConversionTask?: ConversionTask;
}
export declare namespace ImportVolumeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportVolumeResult) => any;
}
export interface ListSnapshotsInRecycleBinRequest {
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The IDs of the snapshots to list. Omit this parameter to list all of the
     *       snapshots that are in the Recycle Bin.</p>
     */
    SnapshotIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ListSnapshotsInRecycleBinRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ListSnapshotsInRecycleBinRequest) => any;
}
/**
 * <p>Information about a snapshot that is currently in the Recycle Bin.</p>
 */
export interface SnapshotRecycleBinInfo {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The date and time when the snaphsot entered the Recycle Bin.</p>
     */
    RecycleBinEnterTime?: Date;
    /**
     * <p>The date and time when the snapshot is to be permanently deleted from the Recycle Bin.</p>
     */
    RecycleBinExitTime?: Date;
    /**
     * <p>The description for the snapshot.</p>
     */
    Description?: string;
    /**
     * <p>The ID of the volume from which the snapshot was created.</p>
     */
    VolumeId?: string;
}
export declare namespace SnapshotRecycleBinInfo {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SnapshotRecycleBinInfo) => any;
}
export interface ListSnapshotsInRecycleBinResult {
    /**
     * <p>Information about the snapshots.</p>
     */
    Snapshots?: SnapshotRecycleBinInfo[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace ListSnapshotsInRecycleBinResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ListSnapshotsInRecycleBinResult) => any;
}
export interface ModifyAddressAttributeRequest {
    /**
     * <p>[EC2-VPC] The allocation ID.</p>
     */
    AllocationId: string | undefined;
    /**
     * <p>The domain name to modify for the IP address.</p>
     */
    DomainName?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyAddressAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyAddressAttributeRequest) => any;
}
export interface ModifyAddressAttributeResult {
    /**
     * <p>Information about the Elastic IP address.</p>
     */
    Address?: AddressAttribute;
}
export declare namespace ModifyAddressAttributeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyAddressAttributeResult) => any;
}
export declare type ModifyAvailabilityZoneOptInStatus = "not-opted-in" | "opted-in";
export interface ModifyAvailabilityZoneGroupRequest {
    /**
     * <p>The name of the Availability Zone group, Local Zone group, or Wavelength Zone
     *       group.</p>
     */
    GroupName: string | undefined;
    /**
     * <p>Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The
     *       only valid value is <code>opted-in</code>. You must contact <a href="https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services">Amazon Web Services Support</a> to opt out of a Local Zone or Wavelength Zone group.</p>
     */
    OptInStatus: ModifyAvailabilityZoneOptInStatus | string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyAvailabilityZoneGroupRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyAvailabilityZoneGroupRequest) => any;
}
export interface ModifyAvailabilityZoneGroupResult {
    /**
     * <p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyAvailabilityZoneGroupResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyAvailabilityZoneGroupResult) => any;
}
export interface ModifyCapacityReservationRequest {
    /**
     * <p>The ID of the Capacity Reservation.</p>
     */
    CapacityReservationId: string | undefined;
    /**
     * <p>The number of instances for which to reserve capacity. The number of instances can't be increased or
     * 		    	decreased by more than <code>1000</code> in a single request.</p>
     */
    InstanceCount?: number;
    /**
     * <p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
     * 			is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
     * 				<code>expired</code> when it reaches its end date and time.</p>
     * 		       <p>The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
     * 			5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p>
     * 		       <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is
     * 				<code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is
     * 				<code>unlimited</code>.</p>
     */
    EndDate?: Date;
    /**
     * <p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
     * 			types:</p>
     * 		       <ul>
     *             <li>
     *                <p>
     *                   <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
     * 					provide an <code>EndDate</code> value if <code>EndDateType</code> is
     * 						<code>unlimited</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
     * 					provide an <code>EndDate</code> value if <code>EndDateType</code> is
     * 						<code>limited</code>.</p>
     *             </li>
     *          </ul>
     */
    EndDateType?: EndDateType | string;
    /**
     * <p>Reserved. Capacity Reservations you have created are accepted by default.</p>
     */
    Accept?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Reserved for future use.</p>
     */
    AdditionalInfo?: string;
}
export declare namespace ModifyCapacityReservationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyCapacityReservationRequest) => any;
}
export interface ModifyCapacityReservationResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyCapacityReservationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyCapacityReservationResult) => any;
}
export interface ModifyCapacityReservationFleetRequest {
    /**
     * <p>The ID of the Capacity Reservation Fleet to modify.</p>
     */
    CapacityReservationFleetId: string | undefined;
    /**
     * <p>The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value,
     * 			together with the instance type weights that you assign to each instance type used by the Fleet
     * 			determine the number of instances for which the Fleet reserves capacity. Both values are based on
     * 			units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a>
     * 			in the Amazon EC2 User Guide.</p>
     */
    TotalTargetCapacity?: number;
    /**
     * <p>The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation
     * 			Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the
     * 			Fleet expire.</p>
     * 		       <p>The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you
     * 			specify <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed
     * 			to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>.</p>
     * 		       <p>You can't specify <b>EndDate</b> and <b>
     * 			RemoveEndDate</b> in the same request.</p>
     */
    EndDate?: Date;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Indicates whether to remove the end date from the Capacity Reservation Fleet. If you remove the
     * 			end date, the Capacity Reservation Fleet does not expire and it remains active until you explicitly
     * 			cancel it using the <b>CancelCapacityReservationFleet</b> action.</p>
     * 		       <p>You can't specify <b>RemoveEndDate</b> and <b>
     * 			EndDate</b> in the same request.</p>
     */
    RemoveEndDate?: boolean;
}
export declare namespace ModifyCapacityReservationFleetRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyCapacityReservationFleetRequest) => any;
}
export interface ModifyCapacityReservationFleetResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyCapacityReservationFleetResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyCapacityReservationFleetResult) => any;
}
/**
 * <p>Information about the DNS server to be used.</p>
 */
export interface DnsServersOptionsModifyStructure {
    /**
     * <p>The IPv4 address range, in CIDR notation, of the DNS servers to be used. You can specify up to
     * 			two DNS servers. Ensure that the DNS servers can be reached by the clients. The specified values
     * 			overwrite the existing values.</p>
     */
    CustomDnsServers?: string[];
    /**
     * <p>Indicates whether DNS servers should be used. Specify <code>False</code> to delete the existing DNS
     * 			servers.</p>
     */
    Enabled?: boolean;
}
export declare namespace DnsServersOptionsModifyStructure {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DnsServersOptionsModifyStructure) => any;
}
export interface ModifyClientVpnEndpointRequest {
    /**
     * <p>The ID of the Client VPN endpoint to modify.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>The ARN of the server certificate to be used. The server certificate must be provisioned in
     * 			Certificate Manager (ACM).</p>
     */
    ServerCertificateArn?: string;
    /**
     * <p>Information about the client connection logging options.</p>
     * 		       <p>If you enable client connection logging, data about client connections is sent to a
     * 			Cloudwatch Logs log stream. The following information is logged:</p>
     * 		       <ul>
     *             <li>
     *                <p>Client connection requests</p>
     *             </li>
     *             <li>
     *                <p>Client connection results (successful and unsuccessful)</p>
     *             </li>
     *             <li>
     *                <p>Reasons for unsuccessful client connection requests</p>
     *             </li>
     *             <li>
     *                <p>Client connection termination time</p>
     *             </li>
     *          </ul>
     */
    ConnectionLogOptions?: ConnectionLogOptions;
    /**
     * <p>Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have
     * 			up to two DNS servers.</p>
     */
    DnsServers?: DnsServersOptionsModifyStructure;
    /**
     * <p>The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>
     * 	        <p>Valid Values: <code>443</code> | <code>1194</code>
     *          </p>
     * 	        <p>Default Value: <code>443</code>
     *          </p>
     */
    VpnPort?: number;
    /**
     * <p>A brief description of the Client VPN endpoint.</p>
     */
    Description?: string;
    /**
     * <p>Indicates whether the VPN is split-tunnel.</p>
     *         <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint</a> in the
     *         	<i>Client VPN Administrator Guide</i>.</p>
     */
    SplitTunnel?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of one or more security groups to apply to the target network.</p>
     */
    SecurityGroupIds?: string[];
    /**
     * <p>The ID of the VPC to associate with the Client VPN endpoint.</p>
     */
    VpcId?: string;
    /**
     * <p>Specify whether to enable the self-service portal for the Client VPN endpoint.</p>
     */
    SelfServicePortal?: SelfServicePortal | string;
    /**
     * <p>The options for managing connection authorization for new client connections.</p>
     */
    ClientConnectOptions?: ClientConnectOptions;
}
export declare namespace ModifyClientVpnEndpointRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyClientVpnEndpointRequest) => any;
}
export interface ModifyClientVpnEndpointResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyClientVpnEndpointResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyClientVpnEndpointResult) => any;
}
export interface ModifyDefaultCreditSpecificationRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The instance family.</p>
     */
    InstanceFamily: UnlimitedSupportedInstanceFamily | string | undefined;
    /**
     * <p>The credit option for CPU usage of the instance family.</p>
     *         <p>Valid Values: <code>standard</code> | <code>unlimited</code>
     *          </p>
     */
    CpuCredits: string | undefined;
}
export declare namespace ModifyDefaultCreditSpecificationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyDefaultCreditSpecificationRequest) => any;
}
export interface ModifyDefaultCreditSpecificationResult {
    /**
     * <p>The default credit option for CPU usage of the instance family.</p>
     */
    InstanceFamilyCreditSpecification?: InstanceFamilyCreditSpecification;
}
export declare namespace ModifyDefaultCreditSpecificationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyDefaultCreditSpecificationResult) => any;
}
export interface ModifyEbsDefaultKmsKeyIdRequest {
    /**
     * <p>The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption.
     *       If this parameter is not specified, your KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is
     *       specified, the encrypted state must be <code>true</code>.</p>
     *          <p>You can specify the KMS key using any of the following:</p>
     *          <ul>
     *             <li>
     *                <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p>
     *             </li>
     *             <li>
     *                <p>Key alias. For example, alias/ExampleAlias.</p>
     *             </li>
     *             <li>
     *                <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p>
     *             </li>
     *             <li>
     *                <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p>
     *             </li>
     *          </ul>
     *          <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid,
     *       the action can appear to complete, but eventually fails.</p>
     *          <p>Amazon EBS does not support asymmetric KMS keys.</p>
     */
    KmsKeyId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyEbsDefaultKmsKeyIdRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyEbsDefaultKmsKeyIdRequest) => any;
}
export interface ModifyEbsDefaultKmsKeyIdResult {
    /**
     * <p>The Amazon Resource Name (ARN) of the default KMS key for encryption by default.</p>
     */
    KmsKeyId?: string;
}
export declare namespace ModifyEbsDefaultKmsKeyIdResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyEbsDefaultKmsKeyIdResult) => any;
}
export interface ModifyFleetRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Indicates whether running instances should be terminated if the total target capacity of
     *          the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>
     */
    ExcessCapacityTerminationPolicy?: FleetExcessCapacityTerminationPolicy | string;
    /**
     * <p>The launch template and overrides.</p>
     */
    LaunchTemplateConfigs?: FleetLaunchTemplateConfigRequest[];
    /**
     * <p>The ID of the EC2 Fleet.</p>
     */
    FleetId: string | undefined;
    /**
     * <p>The size of the EC2 Fleet.</p>
     */
    TargetCapacitySpecification?: TargetCapacitySpecificationRequest;
    /**
     * <p>Reserved.</p>
     */
    Context?: string;
}
export declare namespace ModifyFleetRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyFleetRequest) => any;
}
export interface ModifyFleetResult {
    /**
     * <p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyFleetResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyFleetResult) => any;
}
/**
 * <p>Describes a load permission.</p>
 */
export interface LoadPermissionRequest {
    /**
     * <p>The name of the group.</p>
     */
    Group?: PermissionGroup | string;
    /**
     * <p>The Amazon Web Services account ID.</p>
     */
    UserId?: string;
}
export declare namespace LoadPermissionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: LoadPermissionRequest) => any;
}
/**
 * <p>Describes modifications to the load permissions of an Amazon FPGA image (AFI).</p>
 */
export interface LoadPermissionModifications {
    /**
     * <p>The load permissions to add.</p>
     */
    Add?: LoadPermissionRequest[];
    /**
     * <p>The load permissions to remove.</p>
     */
    Remove?: LoadPermissionRequest[];
}
export declare namespace LoadPermissionModifications {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: LoadPermissionModifications) => any;
}
export declare type OperationType = "add" | "remove";
export interface ModifyFpgaImageAttributeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the AFI.</p>
     */
    FpgaImageId: string | undefined;
    /**
     * <p>The name of the attribute.</p>
     */
    Attribute?: FpgaImageAttributeName | string;
    /**
     * <p>The operation type.</p>
     */
    OperationType?: OperationType | string;
    /**
     * <p>The Amazon Web Services account IDs. This parameter is valid only when modifying the <code>loadPermission</code> attribute.</p>
     */
    UserIds?: string[];
    /**
     * <p>The user groups. This parameter is valid only when modifying the <code>loadPermission</code> attribute.</p>
     */
    UserGroups?: string[];
    /**
     * <p>The product codes. After you add a product code to an AFI, it can't be removed.
     * 		    This parameter is valid only when modifying the <code>productCodes</code> attribute.</p>
     */
    ProductCodes?: string[];
    /**
     * <p>The load permission for the AFI.</p>
     */
    LoadPermission?: LoadPermissionModifications;
    /**
     * <p>A description for the AFI.</p>
     */
    Description?: string;
    /**
     * <p>A name for the AFI.</p>
     */
    Name?: string;
}
export declare namespace ModifyFpgaImageAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyFpgaImageAttributeRequest) => any;
}
export interface ModifyFpgaImageAttributeResult {
    /**
     * <p>Information about the attribute.</p>
     */
    FpgaImageAttribute?: FpgaImageAttribute;
}
export declare namespace ModifyFpgaImageAttributeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyFpgaImageAttributeResult) => any;
}
export interface ModifyHostsRequest {
    /**
     * <p>Specify whether to enable or disable auto-placement.</p>
     */
    AutoPlacement?: AutoPlacement | string;
    /**
     * <p>The IDs of the Dedicated Hosts to modify.</p>
     */
    HostIds: string[] | undefined;
    /**
     * <p>Indicates whether to enable or disable host recovery for the Dedicated Host. For more information,
     * 			see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">
     * 				Host recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>
     */
    HostRecovery?: HostRecovery | string;
    /**
     * <p>Specifies the instance type to be supported by the Dedicated Host. Specify this parameter to
     * 			modify a Dedicated Host to support only a specific instance type.</p>
     *
     * 		       <p>If you want to modify a Dedicated Host to support multiple instance types in its current instance
     * 			family, omit this parameter and specify <b>InstanceFamily</b>
     * 			instead. You cannot specify <b>InstanceType</b> and
     * 			<b>InstanceFamily</b> in the same request.</p>
     */
    InstanceType?: string;
    /**
     * <p>Specifies the instance family to be supported by the Dedicated Host. Specify this parameter
     * 			to modify a Dedicated Host to support multiple instance types within its current
     * 			instance family.</p>
     *
     * 		       <p>If you want to modify a Dedicated Host to support a specific instance type only, omit this parameter
     * 			and specify <b>InstanceType</b> instead. You cannot specify
     * 			<b>InstanceFamily</b> and <b>InstanceType</b>
     * 			in the same request.</p>
     */
    InstanceFamily?: string;
}
export declare namespace ModifyHostsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyHostsRequest) => any;
}
export interface ModifyHostsResult {
    /**
     * <p>The IDs of the Dedicated Hosts that were successfully modified.</p>
     */
    Successful?: string[];
    /**
     * <p>The IDs of the Dedicated Hosts that could not be modified. Check whether the
     *             setting you requested can be used.</p>
     */
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace ModifyHostsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyHostsResult) => any;
}
export interface ModifyIdentityIdFormatRequest {
    /**
     * <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. Specify
     *        <code>all</code> to modify the ID format for all IAM users, IAM roles, and the root user of
     *        the account.</p>
     */
    PrincipalArn: string | undefined;
    /**
     * <p>The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> |
     *           <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     *           <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     *           <code>import-task</code> | <code>internet-gateway</code> | <code>network-acl</code>
     *           | <code>network-acl-association</code> | <code>network-interface</code> |
     *           <code>network-interface-attachment</code> | <code>prefix-list</code> |
     *           <code>route-table</code> | <code>route-table-association</code> |
     *           <code>security-group</code> | <code>subnet</code> |
     *           <code>subnet-cidr-block-association</code> | <code>vpc</code> |
     *           <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p>
     *          <p>Alternatively, use the <code>all-current</code> option to include all resource types that are
     *           currently within their opt-in period for longer IDs.</p>
     */
    Resource: string | undefined;
    /**
     * <p>Indicates whether the resource should use longer IDs (17-character IDs)</p>
     */
    UseLongIds: boolean | undefined;
}
export declare namespace ModifyIdentityIdFormatRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIdentityIdFormatRequest) => any;
}
export interface ModifyIdFormatRequest {
    /**
     * <p>The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> |
     *            <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     *            <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     *            <code>import-task</code> | <code>internet-gateway</code> | <code>network-acl</code>
     *            | <code>network-acl-association</code> | <code>network-interface</code> |
     *            <code>network-interface-attachment</code> | <code>prefix-list</code> |
     *            <code>route-table</code> | <code>route-table-association</code> |
     *            <code>security-group</code> | <code>subnet</code> |
     *            <code>subnet-cidr-block-association</code> | <code>vpc</code> |
     *            <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p>
     *          <p>Alternatively, use the <code>all-current</code> option to include all resource types that are
     *        currently within their opt-in period for longer IDs.</p>
     */
    Resource: string | undefined;
    /**
     * <p>Indicate whether the resource should use longer IDs (17-character IDs).</p>
     */
    UseLongIds: boolean | undefined;
}
export declare namespace ModifyIdFormatRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIdFormatRequest) => any;
}
/**
 * <p>Describes a launch permission modification.</p>
 */
export interface LaunchPermissionModifications {
    /**
     * <p>The Amazon Web Services account ID to add to the list of launch permissions for the AMI.</p>
     */
    Add?: LaunchPermission[];
    /**
     * <p>The Amazon Web Services account ID to remove from the list of launch permissions for the AMI.</p>
     */
    Remove?: LaunchPermission[];
}
export declare namespace LaunchPermissionModifications {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: LaunchPermissionModifications) => any;
}
/**
 * <p>Contains the parameters for ModifyImageAttribute.</p>
 */
export interface ModifyImageAttributeRequest {
    /**
     * <p>The name of the attribute to modify.</p>
     *          <p>Valid values: <code>description</code> | <code>launchPermission</code>
     *          </p>
     */
    Attribute?: string;
    /**
     * <p>A new description for the AMI.</p>
     */
    Description?: AttributeValue;
    /**
     * <p>The ID of the AMI.</p>
     */
    ImageId: string | undefined;
    /**
     * <p>A new launch permission for the AMI.</p>
     */
    LaunchPermission?: LaunchPermissionModifications;
    /**
     * <p>The operation type.
     *        This parameter can be used only when the <code>Attribute</code> parameter is <code>launchPermission</code>.</p>
     */
    OperationType?: OperationType | string;
    /**
     * <p>Not supported.</p>
     */
    ProductCodes?: string[];
    /**
     * <p>The user groups.
     *        This parameter can be used only when the <code>Attribute</code> parameter is <code>launchPermission</code>.</p>
     */
    UserGroups?: string[];
    /**
     * <p>The Amazon Web Services account IDs.
     *        This parameter can be used only when the <code>Attribute</code> parameter is <code>launchPermission</code>.</p>
     */
    UserIds?: string[];
    /**
     * <p>The value of the attribute being modified.
     *        This parameter can be used only when the <code>Attribute</code> parameter is <code>description</code>.</p>
     */
    Value?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *        and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *        Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The Amazon Resource Name (ARN) of an organization. This parameter can be used only when the <code>Attribute</code> parameter is <code>launchPermission</code>.</p>
     */
    OrganizationArns?: string[];
    /**
     * <p>The Amazon Resource Name (ARN) of an organizational unit (OU). This parameter can be used only when the <code>Attribute</code> parameter is <code>launchPermission</code>.</p>
     */
    OrganizationalUnitArns?: string[];
}
export declare namespace ModifyImageAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyImageAttributeRequest) => any;
}
/**
 * <p>Describes information used to set up an EBS volume specified in a block device
 *             mapping.</p>
 */
export interface EbsInstanceBlockDeviceSpecification {
    /**
     * <p>Indicates whether the volume is deleted on instance termination.</p>
     */
    DeleteOnTermination?: boolean;
    /**
     * <p>The ID of the EBS volume.</p>
     */
    VolumeId?: string;
}
export declare namespace EbsInstanceBlockDeviceSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EbsInstanceBlockDeviceSpecification) => any;
}
/**
 * <p>Describes a block device mapping entry.</p>
 */
export interface InstanceBlockDeviceMappingSpecification {
    /**
     * <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
     */
    DeviceName?: string;
    /**
     * <p>Parameters used to automatically set up EBS volumes when the instance is
     *             launched.</p>
     */
    Ebs?: EbsInstanceBlockDeviceSpecification;
    /**
     * <p>suppress the specified device included in the block device mapping.</p>
     */
    NoDevice?: string;
    /**
     * <p>The virtual device name.</p>
     */
    VirtualName?: string;
}
export declare namespace InstanceBlockDeviceMappingSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceBlockDeviceMappingSpecification) => any;
}
export interface BlobAttributeValue {
    Value?: Uint8Array;
}
export declare namespace BlobAttributeValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: BlobAttributeValue) => any;
}
export interface ModifyInstanceAttributeRequest {
    /**
     * <p>Enable or disable source/destination checks, which ensure that the instance
     *             is either the source or the destination of any traffic that it receives.
     *             If the value is <code>true</code>, source/destination checks are enabled;
     *             otherwise, they are disabled. The default value is <code>true</code>.
     *             You must disable source/destination checks if the instance runs services
     *             such as network address translation, routing, or firewalls.</p>
     */
    SourceDestCheck?: AttributeBooleanValue;
    /**
     * <p>The name of the attribute.</p>
     */
    Attribute?: InstanceAttributeName | string;
    /**
     * <p>Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently
     *             attached. The volume must be owned by the caller. If no value is specified for
     *                 <code>DeleteOnTermination</code>, the default is <code>true</code> and the volume is
     *             deleted when the instance is terminated.</p>
     *         <p>To add instance store volumes to an Amazon EBS-backed instance, you must add them when
     *             you launch the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM">Update the block device mapping when launching an instance</a> in the
     *             <i>Amazon EC2 User Guide</i>.</p>
     */
    BlockDeviceMappings?: InstanceBlockDeviceMappingSpecification[];
    /**
     * <p>If the value is <code>true</code>, you can't terminate the instance using the Amazon
     *             EC2 console, CLI, or API; otherwise, you can. You cannot use this parameter for Spot
     *             Instances.</p>
     */
    DisableApiTermination?: AttributeBooleanValue;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Specifies whether the instance is optimized for Amazon EBS I/O. This optimization
     *             provides dedicated throughput to Amazon EBS and an optimized configuration stack to
     *             provide optimal EBS I/O performance. This optimization isn't available with all instance
     *             types. Additional usage charges apply when using an EBS Optimized instance.</p>
     */
    EbsOptimized?: AttributeBooleanValue;
    /**
     * <p>Set to <code>true</code> to enable enhanced networking with ENA for the
     *             instance.</p>
     *         <p>This option is supported only for HVM instances. Specifying this option with a PV
     *             instance can make it unreachable.</p>
     */
    EnaSupport?: AttributeBooleanValue;
    /**
     * <p>[EC2-VPC] Replaces the security groups of the instance with the specified security groups.
     *             You must specify at least one security group, even if it's just the default security group for the VPC. You must
     *             specify the security group ID, not the security group name.</p>
     */
    Groups?: string[];
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId: string | undefined;
    /**
     * <p>Specifies whether an instance stops or terminates when you initiate shutdown from the
     *             instance (using the operating system command for system shutdown).</p>
     */
    InstanceInitiatedShutdownBehavior?: AttributeValue;
    /**
     * <p>Changes the instance type to the specified value. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance
     *             types</a> in the <i>Amazon EC2 User Guide</i>. If the instance type is not valid,
     *             the error returned is <code>InvalidInstanceAttributeValue</code>.</p>
     */
    InstanceType?: AttributeValue;
    /**
     * <p>Changes the instance's kernel to the specified value. We recommend that you use
     *             PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.</p>
     */
    Kernel?: AttributeValue;
    /**
     * <p>Changes the instance's RAM disk to the specified value. We recommend that you use
     *             PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.</p>
     */
    Ramdisk?: AttributeValue;
    /**
     * <p>Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual
     *             Function interface for the instance.</p>
     *         <p>There is no way to disable enhanced networking with the Intel 82599 Virtual Function
     *             interface at this time.</p>
     *         <p>This option is supported only for HVM instances. Specifying this option with a PV
     *             instance can make it unreachable.</p>
     */
    SriovNetSupport?: AttributeValue;
    /**
     * <p>Changes the instance's user data to the specified value. If you are using an Amazon Web Services SDK
     *             or command line tool, base64-encoding is performed for you, and you can load the text
     *             from a file. Otherwise, you must provide base64-encoded text.</p>
     */
    UserData?: BlobAttributeValue;
    /**
     * <p>A new value for the attribute. Use only with the <code>kernel</code>,
     *                 <code>ramdisk</code>, <code>userData</code>, <code>disableApiTermination</code>, or
     *                 <code>instanceInitiatedShutdownBehavior</code> attribute.</p>
     */
    Value?: string;
}
export declare namespace ModifyInstanceAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceAttributeRequest) => any;
}
/**
 * <p>Describes an instance's Capacity Reservation targeting option. You can specify only one parameter
 * 			at a time. If you specify <code>CapacityReservationPreference</code> and
 * 			<code>CapacityReservationTarget</code>, the request fails.</p>
 * 			      <p>Use the <code>CapacityReservationPreference</code> parameter to configure the instance
 * 			to run as an On-Demand Instance or to run in any <code>open</code> Capacity Reservation that has
 * 			matching attributes (instance type, platform, Availability Zone). Use the
 * 			<code>CapacityReservationTarget</code> parameter to explicitly target a specific
 * 			   	Capacity Reservation or a Capacity Reservation group.</p>
 */
export interface CapacityReservationSpecification {
    /**
     * <p>Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
     * 		       <ul>
     *             <li>
     *                <p>
     *                   <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes
     * 				(instance type, platform, Availability Zone).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
     * 					instance runs as an On-Demand Instance.</p>
     *             </li>
     *          </ul>
     */
    CapacityReservationPreference?: CapacityReservationPreference | string;
    /**
     * <p>Information about the target Capacity Reservation or Capacity Reservation group.</p>
     */
    CapacityReservationTarget?: CapacityReservationTarget;
}
export declare namespace CapacityReservationSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CapacityReservationSpecification) => any;
}
export interface ModifyInstanceCapacityReservationAttributesRequest {
    /**
     * <p>The ID of the instance to be modified.</p>
     */
    InstanceId: string | undefined;
    /**
     * <p>Information about the Capacity Reservation targeting option.</p>
     */
    CapacityReservationSpecification: CapacityReservationSpecification | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyInstanceCapacityReservationAttributesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceCapacityReservationAttributesRequest) => any;
}
export interface ModifyInstanceCapacityReservationAttributesResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyInstanceCapacityReservationAttributesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceCapacityReservationAttributesResult) => any;
}
/**
 * <p>Describes the credit option for CPU usage of a burstable performance instance.</p>
 */
export interface InstanceCreditSpecificationRequest {
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
    /**
     * <p>The credit option for CPU usage of the instance. Valid values are
     *                 <code>standard</code> and <code>unlimited</code>.</p>
     *         <p>T3 instances with <code>host</code> tenancy do not support the <code>unlimited</code>
     *             CPU credit option.</p>
     */
    CpuCredits?: string;
}
export declare namespace InstanceCreditSpecificationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceCreditSpecificationRequest) => any;
}
export interface ModifyInstanceCreditSpecificationRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>A unique, case-sensitive token that you provide to ensure idempotency of your
     *             modification request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *                 Idempotency</a>.</p>
     */
    ClientToken?: string;
    /**
     * <p>Information about the credit option for CPU usage.</p>
     */
    InstanceCreditSpecifications: InstanceCreditSpecificationRequest[] | undefined;
}
export declare namespace ModifyInstanceCreditSpecificationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceCreditSpecificationRequest) => any;
}
/**
 * <p>Describes the burstable performance instance whose credit option for CPU usage was
 *             successfully modified.</p>
 */
export interface SuccessfulInstanceCreditSpecificationItem {
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
}
export declare namespace SuccessfulInstanceCreditSpecificationItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SuccessfulInstanceCreditSpecificationItem) => any;
}
export declare enum UnsuccessfulInstanceCreditSpecificationErrorCode {
    INCORRECT_INSTANCE_STATE = "IncorrectInstanceState",
    INSTANCE_CREDIT_SPECIFICATION_NOT_SUPPORTED = "InstanceCreditSpecification.NotSupported",
    INSTANCE_NOT_FOUND = "InvalidInstanceID.NotFound",
    INVALID_INSTANCE_ID = "InvalidInstanceID.Malformed"
}
/**
 * <p>Information about the error for the burstable performance instance whose credit option
 *             for CPU usage was not modified.</p>
 */
export interface UnsuccessfulInstanceCreditSpecificationItemError {
    /**
     * <p>The error code.</p>
     */
    Code?: UnsuccessfulInstanceCreditSpecificationErrorCode | string;
    /**
     * <p>The applicable error message.</p>
     */
    Message?: string;
}
export declare namespace UnsuccessfulInstanceCreditSpecificationItemError {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: UnsuccessfulInstanceCreditSpecificationItemError) => any;
}
/**
 * <p>Describes the burstable performance instance whose credit option for CPU usage was not
 *             modified.</p>
 */
export interface UnsuccessfulInstanceCreditSpecificationItem {
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
    /**
     * <p>The applicable error for the burstable performance instance whose credit option for
     *             CPU usage was not modified.</p>
     */
    Error?: UnsuccessfulInstanceCreditSpecificationItemError;
}
export declare namespace UnsuccessfulInstanceCreditSpecificationItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: UnsuccessfulInstanceCreditSpecificationItem) => any;
}
export interface ModifyInstanceCreditSpecificationResult {
    /**
     * <p>Information about the instances whose credit option for CPU usage was successfully
     *             modified.</p>
     */
    SuccessfulInstanceCreditSpecifications?: SuccessfulInstanceCreditSpecificationItem[];
    /**
     * <p>Information about the instances whose credit option for CPU usage was not
     *             modified.</p>
     */
    UnsuccessfulInstanceCreditSpecifications?: UnsuccessfulInstanceCreditSpecificationItem[];
}
export declare namespace ModifyInstanceCreditSpecificationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceCreditSpecificationResult) => any;
}
export interface ModifyInstanceEventStartTimeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the instance with the scheduled event.</p>
     */
    InstanceId: string | undefined;
    /**
     * <p>The ID of the event whose date and time you are modifying.</p>
     */
    InstanceEventId: string | undefined;
    /**
     * <p>The new date and time when the event will take place.</p>
     */
    NotBefore: Date | undefined;
}
export declare namespace ModifyInstanceEventStartTimeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceEventStartTimeRequest) => any;
}
export interface ModifyInstanceEventStartTimeResult {
    /**
     * <p>Describes a scheduled event for an instance.</p>
     */
    Event?: InstanceStatusEvent;
}
export declare namespace ModifyInstanceEventStartTimeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceEventStartTimeResult) => any;
}
export interface ModifyInstanceEventWindowRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The name of the event window.</p>
     */
    Name?: string;
    /**
     * <p>The ID of the event window.</p>
     */
    InstanceEventWindowId: string | undefined;
    /**
     * <p>The time ranges of the event window.</p>
     */
    TimeRanges?: InstanceEventWindowTimeRangeRequest[];
    /**
     * <p>The cron expression of the event window, for example, <code>* 0-4,20-23 * * 1,5</code>.</p>
     *          <p>Constraints:</p>
     *          <ul>
     *             <li>
     *                <p>Only hour and day of the week values are supported.</p>
     *             </li>
     *             <li>
     *                <p>For day of the week values, you can specify either integers <code>0</code> through
     *                   <code>6</code>, or alternative single values <code>SUN</code> through
     *                   <code>SAT</code>.</p>
     *             </li>
     *             <li>
     *                <p>The minute, month, and year must be specified by <code>*</code>.</p>
     *             </li>
     *             <li>
     *                <p>The hour value must be one or a multiple range, for example, <code>0-4</code> or
     *                   <code>0-4,20-23</code>.</p>
     *             </li>
     *             <li>
     *                <p>Each hour range must be >= 2 hours, for example, <code>0-2</code> or
     *                   <code>20-23</code>.</p>
     *             </li>
     *             <li>
     *                <p>The event window must be >= 4 hours. The combined total time ranges in the event
     *                window must be >= 4 hours.</p>
     *             </li>
     *          </ul>
     *          <p>For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a> on the <i>Wikipedia
     *             website</i>.</p>
     */
    CronExpression?: string;
}
export declare namespace ModifyInstanceEventWindowRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceEventWindowRequest) => any;
}
export interface ModifyInstanceEventWindowResult {
    /**
     * <p>Information about the event window.</p>
     */
    InstanceEventWindow?: InstanceEventWindow;
}
export declare namespace ModifyInstanceEventWindowResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceEventWindowResult) => any;
}
export interface ModifyInstanceMetadataOptionsRequest {
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId: string | undefined;
    /**
     * <p>The state of token usage for your instance metadata requests. If the parameter is not
     *             specified in the request, the default state is <code>optional</code>.</p>
     *         <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata
     *             with or without a signed token header on your request. If you retrieve the IAM role
     *             credentials without a token, the version 1.0 role credentials are returned. If you
     *             retrieve the IAM role credentials using a valid signed token, the version 2.0 role
     *             credentials are returned.</p>
     *         <p>If the state is <code>required</code>, you must send a signed token header with any
     *             instance metadata retrieval requests. In this state, retrieving the IAM role credential
     *             always returns the version 2.0 credentials; the version 1.0 credentials are not
     *             available.</p>
     */
    HttpTokens?: HttpTokensState | string;
    /**
     * <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the
     *             number, the further instance metadata requests can travel. If no parameter is specified, the existing state is maintained.</p>
     *         <p>Possible values: Integers from 1 to 64</p>
     */
    HttpPutResponseHopLimit?: number;
    /**
     * <p>Enables or disables the HTTP metadata endpoint on your instances. If
     *             the parameter is not specified, the existing state is maintained.</p>
     *         <p>If you specify a value of <code>disabled</code>, you cannot access your
     *             instance metadata.</p>
     */
    HttpEndpoint?: InstanceMetadataEndpointState | string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *             and provides an error response. If you have the required permissions, the error response is
     *             <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Enables or disables the IPv6 endpoint for the instance metadata service. This setting
     *             applies only if you have enabled the HTTP metadata endpoint.</p>
     */
    HttpProtocolIpv6?: InstanceMetadataProtocolState | string;
}
export declare namespace ModifyInstanceMetadataOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceMetadataOptionsRequest) => any;
}
export interface ModifyInstanceMetadataOptionsResult {
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
    /**
     * <p>The metadata options for the instance.</p>
     */
    InstanceMetadataOptions?: InstanceMetadataOptionsResponse;
}
export declare namespace ModifyInstanceMetadataOptionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstanceMetadataOptionsResult) => any;
}
export declare type HostTenancy = "dedicated" | "host";
export interface ModifyInstancePlacementRequest {
    /**
     * <p>The affinity setting for the instance.</p>
     */
    Affinity?: Affinity | string;
    /**
     * <p>The name of the placement group in which to place the instance. For spread placement
     *             groups, the instance must have a tenancy of <code>default</code>. For cluster and
     *             partition placement groups, the instance must have a tenancy of <code>default</code> or
     *                 <code>dedicated</code>.</p>
     *         <p>To remove an instance from a placement group, specify an empty string
     *             ("").</p>
     */
    GroupName?: string;
    /**
     * <p>The ID of the Dedicated Host with which to associate the instance.</p>
     */
    HostId?: string;
    /**
     * <p>The ID of the instance that you are modifying.</p>
     */
    InstanceId: string | undefined;
    /**
     * <p>The tenancy for the instance.</p>
     *
     *         <note>
     *             <p>For T3 instances, you can't change the tenancy from <code>dedicated</code>
     *             to <code>host</code>, or from <code>host</code> to <code>dedicated</code>.
     *             Attempting to make one of these unsupported tenancy changes results in the
     *             <code>InvalidTenancy</code> error code.</p>
     *          </note>
     */
    Tenancy?: HostTenancy | string;
    /**
     * <p>The number of the partition in which to place the instance. Valid only if the
     *             placement group strategy is set to <code>partition</code>.</p>
     */
    PartitionNumber?: number;
    /**
     * <p>The ARN of the host resource group in which to place the instance.</p>
     */
    HostResourceGroupArn?: string;
}
export declare namespace ModifyInstancePlacementRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstancePlacementRequest) => any;
}
export interface ModifyInstancePlacementResult {
    /**
     * <p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyInstancePlacementResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyInstancePlacementResult) => any;
}
/**
 * <p>Remove an operating Region from an IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only
 *          discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p>
 *          <p>For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>
 *          </p>
 */
export interface RemoveIpamOperatingRegion {
    /**
     * <p>The name of the operating Region you want to remove.</p>
     */
    RegionName?: string;
}
export declare namespace RemoveIpamOperatingRegion {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RemoveIpamOperatingRegion) => any;
}
export interface ModifyIpamRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the IPAM you want to modify.</p>
     */
    IpamId: string | undefined;
    /**
     * <p>The description of the IPAM you want to modify.</p>
     */
    Description?: string;
    /**
     * <p>Choose the operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only
     *          discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p>
     *          <p>For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    AddOperatingRegions?: AddIpamOperatingRegion[];
    /**
     * <p>The operating Regions to remove.</p>
     */
    RemoveOperatingRegions?: RemoveIpamOperatingRegion[];
}
export declare namespace ModifyIpamRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIpamRequest) => any;
}
export interface ModifyIpamResult {
    /**
     * <p>The results of the modification.</p>
     */
    Ipam?: Ipam;
}
export declare namespace ModifyIpamResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIpamResult) => any;
}
export interface ModifyIpamPoolRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the IPAM pool you want to modify.</p>
     */
    IpamPoolId: string | undefined;
    /**
     * <p>The description of the IPAM pool you want to modify.</p>
     */
    Description?: string;
    /**
     * <p>If true, IPAM will continuously look for resources within the CIDR range of this pool
     *          and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for
     *          these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import
     *          a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently
     *          marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM
     *          discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
     *       </p>
     *          <p>A locale must be set on the pool for this feature to work.</p>
     */
    AutoImport?: boolean;
    /**
     * <p>The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. Possible
     *          netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are  0 - 128. The minimum netmask
     *          length must be less than the maximum netmask length.</p>
     */
    AllocationMinNetmaskLength?: number;
    /**
     * <p>The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. Possible
     *          netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are  0 - 128.The maximum netmask
     *          length must be greater than the minimum netmask length.</p>
     */
    AllocationMaxNetmaskLength?: number;
    /**
     * <p>The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.</p>
     */
    AllocationDefaultNetmaskLength?: number;
    /**
     * <p>Clear the default netmask length allocation rule for this pool.</p>
     */
    ClearAllocationDefaultNetmaskLength?: boolean;
    /**
     * <p>Add tag allocation rules to a pool. For more information about allocation rules, see <a href="/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    AddAllocationResourceTags?: RequestIpamResourceTag[];
    /**
     * <p>Remove tag allocation rules from a pool.</p>
     */
    RemoveAllocationResourceTags?: RequestIpamResourceTag[];
}
export declare namespace ModifyIpamPoolRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIpamPoolRequest) => any;
}
export interface ModifyIpamPoolResult {
    /**
     * <p>The results of the modification.</p>
     */
    IpamPool?: IpamPool;
}
export declare namespace ModifyIpamPoolResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIpamPoolResult) => any;
}
export interface ModifyIpamResourceCidrRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the resource you want to modify.</p>
     */
    ResourceId: string | undefined;
    /**
     * <p>The CIDR of the resource you want to modify.</p>
     */
    ResourceCidr: string | undefined;
    /**
     * <p>The Amazon Web Services Region of the resource you want to modify.</p>
     */
    ResourceRegion: string | undefined;
    /**
     * <p>The ID of the current scope that the resource CIDR is in.</p>
     */
    CurrentIpamScopeId: string | undefined;
    /**
     * <p>The ID of the scope you want to transfer the resource CIDR to.</p>
     */
    DestinationIpamScopeId?: string;
    /**
     * <p>Determines if the resource is monitored by IPAM. If a resource is monitored, the resource is discovered by IPAM and you can view details about the resource’s CIDR.</p>
     */
    Monitored: boolean | undefined;
}
export declare namespace ModifyIpamResourceCidrRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIpamResourceCidrRequest) => any;
}
export interface ModifyIpamResourceCidrResult {
    /**
     * <p>The CIDR for an IPAM resource.</p>
     */
    IpamResourceCidr?: IpamResourceCidr;
}
export declare namespace ModifyIpamResourceCidrResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIpamResourceCidrResult) => any;
}
export interface ModifyIpamScopeRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the scope you want to modify.</p>
     */
    IpamScopeId: string | undefined;
    /**
     * <p>The description of the scope you want to modify.</p>
     */
    Description?: string;
}
export declare namespace ModifyIpamScopeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIpamScopeRequest) => any;
}
export interface ModifyIpamScopeResult {
    /**
     * <p>The results of the modification.</p>
     */
    IpamScope?: IpamScope;
}
export declare namespace ModifyIpamScopeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyIpamScopeResult) => any;
}
export interface ModifyLaunchTemplateRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the
     *             request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *                 Idempotency</a>.</p>
     *         <p>Constraint: Maximum 128 ASCII characters.</p>
     */
    ClientToken?: string;
    /**
     * <p>The ID of the launch template. You must specify either the launch template ID or
     *             launch template name in the request.</p>
     */
    LaunchTemplateId?: string;
    /**
     * <p>The name of the launch template. You must specify either the launch template ID or
     *             launch template name in the request.</p>
     */
    LaunchTemplateName?: string;
    /**
     * <p>The version number of the launch template to set as the default version.</p>
     */
    DefaultVersion?: string;
}
export declare namespace ModifyLaunchTemplateRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyLaunchTemplateRequest) => any;
}
export interface ModifyLaunchTemplateResult {
    /**
     * <p>Information about the launch template.</p>
     */
    LaunchTemplate?: LaunchTemplate;
}
export declare namespace ModifyLaunchTemplateResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyLaunchTemplateResult) => any;
}
/**
 * <p>An entry for a prefix list.</p>
 */
export interface RemovePrefixListEntry {
    /**
     * <p>The CIDR block.</p>
     */
    Cidr: string | undefined;
}
export declare namespace RemovePrefixListEntry {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RemovePrefixListEntry) => any;
}
export interface ModifyManagedPrefixListRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the prefix list.</p>
     */
    PrefixListId: string | undefined;
    /**
     * <p>The current version of the prefix list.</p>
     */
    CurrentVersion?: number;
    /**
     * <p>A name for the prefix list.</p>
     */
    PrefixListName?: string;
    /**
     * <p>One or more entries to add to the prefix list.</p>
     */
    AddEntries?: AddPrefixListEntry[];
    /**
     * <p>One or more entries to remove from the prefix list.</p>
     */
    RemoveEntries?: RemovePrefixListEntry[];
    /**
     * <p>The maximum number of entries for the prefix list. You cannot modify the entries
     *             of a prefix list and modify the size of a prefix list at the same time.</p>
     *         <p>If any of the resources that reference the prefix list cannot support the new
     *             maximum size, the modify operation fails. Check the state message for the IDs of
     *             the first ten resources that do not support the new maximum size.</p>
     */
    MaxEntries?: number;
}
export declare namespace ModifyManagedPrefixListRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyManagedPrefixListRequest) => any;
}
export interface ModifyManagedPrefixListResult {
    /**
     * <p>Information about the prefix list.</p>
     */
    PrefixList?: ManagedPrefixList;
}
export declare namespace ModifyManagedPrefixListResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyManagedPrefixListResult) => any;
}
/**
 * <p>Describes an attachment change.</p>
 */
export interface NetworkInterfaceAttachmentChanges {
    /**
     * <p>The ID of the network interface attachment.</p>
     */
    AttachmentId?: string;
    /**
     * <p>Indicates whether the network interface is deleted when the instance is terminated.</p>
     */
    DeleteOnTermination?: boolean;
}
export declare namespace NetworkInterfaceAttachmentChanges {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: NetworkInterfaceAttachmentChanges) => any;
}
/**
 * <p>Contains the parameters for ModifyNetworkInterfaceAttribute.</p>
 */
export interface ModifyNetworkInterfaceAttributeRequest {
    /**
     * <p>Information about the interface attachment. If modifying the 'delete on termination' attribute, you must specify the ID of the interface attachment.</p>
     */
    Attachment?: NetworkInterfaceAttachmentChanges;
    /**
     * <p>A description for the network interface.</p>
     */
    Description?: AttributeValue;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *             and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *             Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Changes the security groups for the network interface. The new set of groups you specify replaces the current set. You must specify at least one group, even if it's just the default security group in the VPC. You must specify the ID of the security group, not the name.</p>
     */
    Groups?: string[];
    /**
     * <p>The ID of the network interface.</p>
     */
    NetworkInterfaceId: string | undefined;
    /**
     * <p>Enable or disable source/destination checks, which ensure that the instance
     *             is either the source or the destination of any traffic that it receives.
     *             If the value is <code>true</code>, source/destination checks are enabled;
     *             otherwise, they are disabled. The default value is <code>true</code>.
     *             You must disable source/destination checks if the instance runs services
     *             such as network address translation, routing, or firewalls.</p>
     */
    SourceDestCheck?: AttributeBooleanValue;
}
export declare namespace ModifyNetworkInterfaceAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyNetworkInterfaceAttributeRequest) => any;
}
export interface ModifyPrivateDnsNameOptionsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *             and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *             Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
    /**
     * <p>The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be
     *             based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based
     *             on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance
     *             IPv4 address or the instance ID.</p>
     */
    PrivateDnsHostnameType?: HostnameType | string;
    /**
     * <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
     */
    EnableResourceNameDnsARecord?: boolean;
    /**
     * <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
     */
    EnableResourceNameDnsAAAARecord?: boolean;
}
export declare namespace ModifyPrivateDnsNameOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyPrivateDnsNameOptionsRequest) => any;
}
export interface ModifyPrivateDnsNameOptionsResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyPrivateDnsNameOptionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyPrivateDnsNameOptionsResult) => any;
}
/**
 * <p>Contains the parameters for ModifyReservedInstances.</p>
 */
export interface ModifyReservedInstancesRequest {
    /**
     * <p>The IDs of the Reserved Instances to modify.</p>
     */
    ReservedInstancesIds: string[] | undefined;
    /**
     * <p>A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more information, see
     *    		<a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     */
    ClientToken?: string;
    /**
     * <p>The configuration settings for the Reserved Instances to modify.</p>
     */
    TargetConfigurations: ReservedInstancesConfiguration[] | undefined;
}
export declare namespace ModifyReservedInstancesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyReservedInstancesRequest) => any;
}
/**
 * <p>Contains the output of ModifyReservedInstances.</p>
 */
export interface ModifyReservedInstancesResult {
    /**
     * <p>The ID for the modification.</p>
     */
    ReservedInstancesModificationId?: string;
}
export declare namespace ModifyReservedInstancesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyReservedInstancesResult) => any;
}
/**
 * <p>Describes a security group rule.</p>
 *         <p>You must specify exactly one of the following parameters, based on the rule type:</p>
 *         <ul>
 *             <li>
 *                <p>CidrIpv4</p>
 *             </li>
 *             <li>
 *                <p>CidrIpv6</p>
 *             </li>
 *             <li>
 *                <p>PrefixListId</p>
 *             </li>
 *             <li>
 *                <p>ReferencedGroupId</p>
 *             </li>
 *          </ul>
 *         <p>When you modify a rule, you cannot change the rule type. For example, if the rule
 *             uses an IPv4 address range, you must use <code>CidrIpv4</code> to specify a new IPv4
 *             address range.</p>
 */
export interface SecurityGroupRuleRequest {
    /**
     * <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>,
     *                 <code>icmpv6</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). </p>
     *         <p>Use <code>-1</code> to specify all protocols.</p>
     */
    IpProtocol?: string;
    /**
     * <p>The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type. A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>
     */
    FromPort?: number;
    /**
     * <p>The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes. </p>
     */
    ToPort?: number;
    /**
     * <p>The IPv4 CIDR range. To specify a single IPv4 address, use the /32 prefix length. </p>
     */
    CidrIpv4?: string;
    /**
     * <p>The IPv6 CIDR range. To specify a single IPv6 address, use the /128 prefix length.</p>
     */
    CidrIpv6?: string;
    /**
     * <p>The ID of the prefix list.</p>
     */
    PrefixListId?: string;
    /**
     * <p>The ID of the security group that is referenced in the security group rule.</p>
     */
    ReferencedGroupId?: string;
    /**
     * <p>The description of the security group rule.</p>
     */
    Description?: string;
}
export declare namespace SecurityGroupRuleRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SecurityGroupRuleRequest) => any;
}
/**
 * <p>Describes an update to a security group rule.</p>
 */
export interface SecurityGroupRuleUpdate {
    /**
     * <p>The ID of the security group rule.</p>
     */
    SecurityGroupRuleId?: string;
    /**
     * <p>Information about the security group rule.</p>
     */
    SecurityGroupRule?: SecurityGroupRuleRequest;
}
export declare namespace SecurityGroupRuleUpdate {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SecurityGroupRuleUpdate) => any;
}
export interface ModifySecurityGroupRulesRequest {
    /**
     * <p>The ID of the security group.</p>
     */
    GroupId: string | undefined;
    /**
     * <p>Information about the security group properties to update.</p>
     */
    SecurityGroupRules: SecurityGroupRuleUpdate[] | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifySecurityGroupRulesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifySecurityGroupRulesRequest) => any;
}
export interface ModifySecurityGroupRulesResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace ModifySecurityGroupRulesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifySecurityGroupRulesResult) => any;
}
/**
 * <p>Describes modifications to the list of create volume permissions for a volume.</p>
 */
export interface CreateVolumePermissionModifications {
    /**
     * <p>Adds the specified Amazon Web Services account ID or group to the list.</p>
     */
    Add?: CreateVolumePermission[];
    /**
     * <p>Removes the specified Amazon Web Services account ID or group from the list.</p>
     */
    Remove?: CreateVolumePermission[];
}
export declare namespace CreateVolumePermissionModifications {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVolumePermissionModifications) => any;
}
export interface ModifySnapshotAttributeRequest {
    /**
     * <p>The snapshot attribute to modify. Only volume creation permissions can be modified.</p>
     */
    Attribute?: SnapshotAttributeName | string;
    /**
     * <p>A JSON representation of the snapshot attribute modification.</p>
     */
    CreateVolumePermission?: CreateVolumePermissionModifications;
    /**
     * <p>The group to modify for the snapshot.</p>
     */
    GroupNames?: string[];
    /**
     * <p>The type of operation to perform to the attribute.</p>
     */
    OperationType?: OperationType | string;
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId: string | undefined;
    /**
     * <p>The account ID to modify for the snapshot.</p>
     */
    UserIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifySnapshotAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifySnapshotAttributeRequest) => any;
}
export declare enum TargetStorageTier {
    archive = "archive"
}
export interface ModifySnapshotTierRequest {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId: string | undefined;
    /**
     * <p>The name of the storage tier. You must specify <code>archive</code>.</p>
     */
    StorageTier?: TargetStorageTier | string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifySnapshotTierRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifySnapshotTierRequest) => any;
}
export interface ModifySnapshotTierResult {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The date and time when the archive process was started.</p>
     */
    TieringStartTime?: Date;
}
export declare namespace ModifySnapshotTierResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifySnapshotTierResult) => any;
}
/**
 * <p>Contains the parameters for ModifySpotFleetRequest.</p>
 */
export interface ModifySpotFleetRequestRequest {
    /**
     * <p>Indicates whether running Spot Instances should be terminated if the target capacity
     *             of the Spot Fleet request is decreased below the current size of the Spot Fleet.</p>
     */
    ExcessCapacityTerminationPolicy?: ExcessCapacityTerminationPolicy | string;
    /**
     * <p>The launch template and overrides. You can only use this parameter if you specified a
     *             launch template (<code>LaunchTemplateConfigs</code>) in your Spot Fleet request. If you
     *             specified <code>LaunchSpecifications</code> in your Spot Fleet request, then omit this
     *             parameter.</p>
     */
    LaunchTemplateConfigs?: LaunchTemplateConfig[];
    /**
     * <p>The ID of the Spot Fleet request.</p>
     */
    SpotFleetRequestId: string | undefined;
    /**
     * <p>The size of the fleet.</p>
     */
    TargetCapacity?: number;
    /**
     * <p>The number of On-Demand Instances in the fleet.</p>
     */
    OnDemandTargetCapacity?: number;
    /**
     * <p>Reserved.</p>
     */
    Context?: string;
}
export declare namespace ModifySpotFleetRequestRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifySpotFleetRequestRequest) => any;
}
/**
 * <p>Contains the output of ModifySpotFleetRequest.</p>
 */
export interface ModifySpotFleetRequestResponse {
    /**
     * <p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>
     */
    Return?: boolean;
}
export declare namespace ModifySpotFleetRequestResponse {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifySpotFleetRequestResponse) => any;
}
export interface ModifySubnetAttributeRequest {
    /**
     * <p>Specify <code>true</code> to indicate that network interfaces created in the
     *             specified subnet should be assigned an IPv6 address. This includes a network interface
     *             that's created when launching an instance into the subnet (the instance therefore
     *             receives an IPv6 address). </p>
     *         <p>If you enable the IPv6 addressing feature for your subnet, your network interface
     *             or instance only receives an IPv6 address if it's created using version
     *                 <code>2016-11-15</code> or later of the Amazon EC2 API.</p>
     */
    AssignIpv6AddressOnCreation?: AttributeBooleanValue;
    /**
     * <p>Specify <code>true</code> to indicate that network interfaces attached to instances created in the
     *             specified subnet should be assigned a public IPv4 address.</p>
     */
    MapPublicIpOnLaunch?: AttributeBooleanValue;
    /**
     * <p>The ID of the subnet.</p>
     */
    SubnetId: string | undefined;
    /**
     * <p>Specify <code>true</code> to indicate that network interfaces  attached to instances created in the
     *             specified subnet should be assigned a customer-owned IPv4 address.</p>
     *         <p>When this value is <code>true</code>, you must specify the customer-owned IP pool using <code>CustomerOwnedIpv4Pool</code>.</p>
     */
    MapCustomerOwnedIpOnLaunch?: AttributeBooleanValue;
    /**
     * <p>The customer-owned IPv4 address pool associated with the subnet.</p>
     *         <p>You must set this value when you specify <code>true</code> for <code>MapCustomerOwnedIpOnLaunch</code>.</p>
     */
    CustomerOwnedIpv4Pool?: string;
    /**
     * <p>Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet
     *             should return synthetic IPv6 addresses for IPv4-only destinations.</p>
     */
    EnableDns64?: AttributeBooleanValue;
    /**
     * <p>The type of hostnames to assign to instances in the subnet at launch. For IPv4 only subnets, an
     *             instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance
     *             DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS
     *             names use the instance IPv4 address or the instance ID.</p>
     */
    PrivateDnsHostnameTypeOnLaunch?: HostnameType | string;
    /**
     * <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
     */
    EnableResourceNameDnsARecordOnLaunch?: AttributeBooleanValue;
    /**
     * <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
     */
    EnableResourceNameDnsAAAARecordOnLaunch?: AttributeBooleanValue;
    /**
     * <p>
     *             Indicates the device position for local network interfaces in this subnet. For example,
     *             <code>1</code> indicates local network interfaces in this subnet are the secondary
     *             network interface (eth1). A local network interface cannot be the primary network
     *             interface (eth0).
     *         </p>
     */
    EnableLniAtDeviceIndex?: number;
    /**
     * <p>
     *             Specify <code>true</code> to indicate that local network interfaces at the current
     *             position should be disabled.
     *         </p>
     */
    DisableLniAtDeviceIndex?: AttributeBooleanValue;
}
export declare namespace ModifySubnetAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifySubnetAttributeRequest) => any;
}
export interface ModifyTrafficMirrorFilterNetworkServicesRequest {
    /**
     * <p>The ID of the Traffic Mirror filter.</p>
     */
    TrafficMirrorFilterId: string | undefined;
    /**
     * <p>The network service, for example Amazon DNS, that you want to mirror.</p>
     */
    AddNetworkServices?: (TrafficMirrorNetworkService | string)[];
    /**
     * <p>The network service, for example Amazon DNS, that you no longer want to mirror.</p>
     */
    RemoveNetworkServices?: (TrafficMirrorNetworkService | string)[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyTrafficMirrorFilterNetworkServicesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTrafficMirrorFilterNetworkServicesRequest) => any;
}
export interface ModifyTrafficMirrorFilterNetworkServicesResult {
    /**
     * <p>The Traffic Mirror filter that the network service is associated with.</p>
     */
    TrafficMirrorFilter?: TrafficMirrorFilter;
}
export declare namespace ModifyTrafficMirrorFilterNetworkServicesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTrafficMirrorFilterNetworkServicesResult) => any;
}
export declare type TrafficMirrorFilterRuleField = "description" | "destination-port-range" | "protocol" | "source-port-range";
export interface ModifyTrafficMirrorFilterRuleRequest {
    /**
     * <p>The ID of the Traffic Mirror rule.</p>
     */
    TrafficMirrorFilterRuleId: string | undefined;
    /**
     * <p>The type of traffic to assign to the rule.</p>
     */
    TrafficDirection?: TrafficDirection | string;
    /**
     * <p>The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
     *          direction. The rules are processed in ascending order by rule number.</p>
     */
    RuleNumber?: number;
    /**
     * <p>The action to assign to the rule.</p>
     */
    RuleAction?: TrafficMirrorRuleAction | string;
    /**
     * <p>The destination ports that are associated with the Traffic Mirror rule.</p>
     */
    DestinationPortRange?: TrafficMirrorPortRangeRequest;
    /**
     * <p>The port range to assign to the Traffic Mirror rule.</p>
     */
    SourcePortRange?: TrafficMirrorPortRangeRequest;
    /**
     * <p>The protocol, for example TCP, to assign to the Traffic Mirror rule.</p>
     */
    Protocol?: number;
    /**
     * <p>The destination CIDR block to assign to the Traffic Mirror rule.</p>
     */
    DestinationCidrBlock?: string;
    /**
     * <p>The source CIDR block to assign to the Traffic Mirror rule.</p>
     */
    SourceCidrBlock?: string;
    /**
     * <p>The description to assign to the Traffic Mirror rule.</p>
     */
    Description?: string;
    /**
     * <p>The properties that you want to remove from the Traffic Mirror filter rule.</p>
     *          <p>When you remove a property from a Traffic Mirror filter rule, the property is set to the default.</p>
     */
    RemoveFields?: (TrafficMirrorFilterRuleField | string)[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyTrafficMirrorFilterRuleRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTrafficMirrorFilterRuleRequest) => any;
}
export interface ModifyTrafficMirrorFilterRuleResult {
    /**
     * <p>Modifies a Traffic Mirror rule.</p>
     */
    TrafficMirrorFilterRule?: TrafficMirrorFilterRule;
}
export declare namespace ModifyTrafficMirrorFilterRuleResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTrafficMirrorFilterRuleResult) => any;
}
export declare type TrafficMirrorSessionField = "description" | "packet-length" | "virtual-network-id";
export interface ModifyTrafficMirrorSessionRequest {
    /**
     * <p>The ID of the Traffic Mirror session.</p>
     */
    TrafficMirrorSessionId: string | undefined;
    /**
     * <p>The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering connection with the source.</p>
     */
    TrafficMirrorTargetId?: string;
    /**
     * <p>The ID of the Traffic Mirror filter.</p>
     */
    TrafficMirrorFilterId?: string;
    /**
     * <p>The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet.</p>
     */
    PacketLength?: number;
    /**
     * <p>The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>
     *          <p>Valid values are 1-32766.</p>
     */
    SessionNumber?: number;
    /**
     * <p>The virtual network ID of the Traffic Mirror session.</p>
     */
    VirtualNetworkId?: number;
    /**
     * <p>The description to assign to the Traffic Mirror session.</p>
     */
    Description?: string;
    /**
     * <p>The properties that you want to remove from the Traffic Mirror session.</p>
     *          <p>When you remove a property from a Traffic Mirror session, the property is set to the default.</p>
     */
    RemoveFields?: (TrafficMirrorSessionField | string)[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyTrafficMirrorSessionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTrafficMirrorSessionRequest) => any;
}
export interface ModifyTrafficMirrorSessionResult {
    /**
     * <p>Information about the Traffic Mirror session.</p>
     */
    TrafficMirrorSession?: TrafficMirrorSession;
}
export declare namespace ModifyTrafficMirrorSessionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTrafficMirrorSessionResult) => any;
}
/**
 * <p>The transit gateway options.</p>
 */
export interface ModifyTransitGatewayOptions {
    /**
     * <p>Adds IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.</p>
     */
    AddTransitGatewayCidrBlocks?: string[];
    /**
     * <p>Removes CIDR blocks for the transit gateway.</p>
     */
    RemoveTransitGatewayCidrBlocks?: string[];
    /**
     * <p>Enable or disable Equal Cost Multipath Protocol support.</p>
     */
    VpnEcmpSupport?: VpnEcmpSupportValue | string;
    /**
     * <p>Enable or disable DNS support.</p>
     */
    DnsSupport?: DnsSupportValue | string;
    /**
     * <p>Enable or disable automatic acceptance of attachment requests.</p>
     */
    AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | string;
    /**
     * <p>Enable or disable automatic association with the default association route table.</p>
     */
    DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | string;
    /**
     * <p>The ID of the default association route table.</p>
     */
    AssociationDefaultRouteTableId?: string;
    /**
     * <p>Enable or disable automatic propagation of routes to the default propagation route table.</p>
     */
    DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | string;
    /**
     * <p>The ID of the default propagation route table.</p>
     */
    PropagationDefaultRouteTableId?: string;
}
export declare namespace ModifyTransitGatewayOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTransitGatewayOptions) => any;
}
export interface ModifyTransitGatewayRequest {
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId: string | undefined;
    /**
     * <p>The description for the transit gateway.</p>
     */
    Description?: string;
    /**
     * <p>The options to modify.</p>
     */
    Options?: ModifyTransitGatewayOptions;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyTransitGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTransitGatewayRequest) => any;
}
export interface ModifyTransitGatewayResult {
    /**
     * <p>Describes a transit gateway.</p>
     */
    TransitGateway?: TransitGateway;
}
export declare namespace ModifyTransitGatewayResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTransitGatewayResult) => any;
}
export interface ModifyTransitGatewayPrefixListReferenceRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the prefix list.</p>
     */
    PrefixListId: string | undefined;
    /**
     * <p>The ID of the attachment to which traffic is routed.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>Indicates whether to drop traffic that matches this route.</p>
     */
    Blackhole?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyTransitGatewayPrefixListReferenceRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTransitGatewayPrefixListReferenceRequest) => any;
}
export interface ModifyTransitGatewayPrefixListReferenceResult {
    /**
     * <p>Information about the prefix list reference.</p>
     */
    TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export declare namespace ModifyTransitGatewayPrefixListReferenceResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTransitGatewayPrefixListReferenceResult) => any;
}
/**
 * <p>Describes the options for a VPC attachment.</p>
 */
export interface ModifyTransitGatewayVpcAttachmentRequestOptions {
    /**
     * <p>Enable or disable DNS support. The default is <code>enable</code>.</p>
     */
    DnsSupport?: DnsSupportValue | string;
    /**
     * <p>Enable or disable IPv6 support. The default is <code>enable</code>.</p>
     */
    Ipv6Support?: Ipv6SupportValue | string;
    /**
     * <p>Enable or disable support for appliance mode. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. The default is <code>disable</code>.</p>
     */
    ApplianceModeSupport?: ApplianceModeSupportValue | string;
}
export declare namespace ModifyTransitGatewayVpcAttachmentRequestOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTransitGatewayVpcAttachmentRequestOptions) => any;
}
export interface ModifyTransitGatewayVpcAttachmentRequest {
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>The IDs of one or more subnets to add. You can specify at most one subnet per Availability Zone.</p>
     */
    AddSubnetIds?: string[];
    /**
     * <p>The IDs of one or more subnets to remove.</p>
     */
    RemoveSubnetIds?: string[];
    /**
     * <p>The new VPC attachment options.</p>
     */
    Options?: ModifyTransitGatewayVpcAttachmentRequestOptions;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyTransitGatewayVpcAttachmentRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTransitGatewayVpcAttachmentRequest) => any;
}
export interface ModifyTransitGatewayVpcAttachmentResult {
    /**
     * <p>Information about the modified attachment.</p>
     */
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare namespace ModifyTransitGatewayVpcAttachmentResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyTransitGatewayVpcAttachmentResult) => any;
}
export interface ModifyVolumeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the volume.</p>
     */
    VolumeId: string | undefined;
    /**
     * <p>The target size of the volume, in GiB. The target volume size must be greater than or
     *       equal to the existing size of the volume.</p>
     *          <p>The following are the supported volumes sizes for each volume type:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>gp2</code> and <code>gp3</code>: 1-16,384</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>io1</code> and <code>io2</code>: 4-16,384</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>st1</code> and <code>sc1</code>: 125-16,384</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>standard</code>: 1-1,024</p>
     *             </li>
     *          </ul>
     *          <p>Default: The existing size is retained.</p>
     */
    Size?: number;
    /**
     * <p>The target EBS volume type of the volume. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     *          <p>Default: The existing type is retained.</p>
     */
    VolumeType?: VolumeType | string;
    /**
     * <p>The target IOPS rate of the volume. This parameter is valid only for <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes.</p>
     *          <p>The following are the supported values for each volume type:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>gp3</code>: 3,000-16,000 IOPS</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>io1</code>: 100-64,000 IOPS</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>io2</code>: 100-64,000 IOPS</p>
     *             </li>
     *          </ul>
     *          <p>Default: The existing value is retained if you keep the same volume type. If you change
     *       the volume type to <code>io1</code>, <code>io2</code>, or <code>gp3</code>, the default is 3,000.</p>
     */
    Iops?: number;
    /**
     * <p>The target throughput of the volume, in MiB/s. This parameter is valid only for <code>gp3</code> volumes.
     *       The maximum value is 1,000.</p>
     *          <p>Default: The existing value is retained if the source and target volume type is <code>gp3</code>.
     *       Otherwise, the default value is 125.</p>
     *   	      <p>Valid Range: Minimum value of 125. Maximum value of 1000.</p>
     */
    Throughput?: number;
    /**
     * <p>Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
     * 		volume to up to 16 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">
     * 			Nitro-based instances</a> in the same Availability Zone. This parameter is
     * 		supported with <code>io1</code> and <code>io2</code> volumes only. For more information, see
     * 		<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html">
     * 			Amazon EBS Multi-Attach</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     */
    MultiAttachEnabled?: boolean;
}
export declare namespace ModifyVolumeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVolumeRequest) => any;
}
export interface ModifyVolumeResult {
    /**
     * <p>Information about the volume modification.</p>
     */
    VolumeModification?: VolumeModification;
}
export declare namespace ModifyVolumeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVolumeResult) => any;
}
export interface ModifyVolumeAttributeRequest {
    /**
     * <p>Indicates whether the volume should be auto-enabled for I/O operations.</p>
     */
    AutoEnableIO?: AttributeBooleanValue;
    /**
     * <p>The ID of the volume.</p>
     */
    VolumeId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyVolumeAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVolumeAttributeRequest) => any;
}
export interface ModifyVpcAttributeRequest {
    /**
     * <p>Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS hostnames; otherwise, they do not.</p>
     *          <p>You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute. You can only enable DNS hostnames if you've enabled DNS support.</p>
     */
    EnableDnsHostnames?: AttributeBooleanValue;
    /**
     * <p>Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to
     * 			the Amazon provided DNS server at the 169.254.169.253 IP address, or the reserved IP
     * 			address at the base of the VPC network range "plus two" succeed. If disabled, the Amazon
     * 			provided DNS service in the VPC that resolves public DNS hostnames to IP addresses is
     * 			not enabled.</p>
     *          <p>You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute.</p>
     */
    EnableDnsSupport?: AttributeBooleanValue;
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
}
export declare namespace ModifyVpcAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcAttributeRequest) => any;
}
/**
 * <p>Contains the parameters for ModifyVpcEndpoint.</p>
 */
export interface ModifyVpcEndpointRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the endpoint.</p>
     */
    VpcEndpointId: string | undefined;
    /**
     * <p>(Gateway endpoint) Specify <code>true</code> to reset the policy document to the
     *             default policy. The default policy allows full access to the service.</p>
     */
    ResetPolicy?: boolean;
    /**
     * <p>(Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must
     *             be in valid JSON format.</p>
     */
    PolicyDocument?: string;
    /**
     * <p>(Gateway endpoint) One or more route tables IDs to associate with the endpoint.</p>
     */
    AddRouteTableIds?: string[];
    /**
     * <p>(Gateway endpoint) One or more route table IDs to disassociate from the endpoint.</p>
     */
    RemoveRouteTableIds?: string[];
    /**
     * <p>(Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet.</p>
     */
    AddSubnetIds?: string[];
    /**
     * <p>(Interface endpoint) One or more subnets IDs in which to remove the endpoint.</p>
     */
    RemoveSubnetIds?: string[];
    /**
     * <p>(Interface endpoint) One or more security group IDs to associate with the network interface.</p>
     */
    AddSecurityGroupIds?: string[];
    /**
     * <p>(Interface endpoint) One or more security group IDs to disassociate from the network interface.</p>
     */
    RemoveSecurityGroupIds?: string[];
    /**
     * <p>(Interface endpoint) Indicates whether a private hosted zone is associated with the
     *             VPC.</p>
     */
    PrivateDnsEnabled?: boolean;
}
export declare namespace ModifyVpcEndpointRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcEndpointRequest) => any;
}
export interface ModifyVpcEndpointResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyVpcEndpointResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcEndpointResult) => any;
}
export interface ModifyVpcEndpointConnectionNotificationRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the notification.</p>
     */
    ConnectionNotificationId: string | undefined;
    /**
     * <p>The ARN for the SNS topic for the notification.</p>
     */
    ConnectionNotificationArn?: string;
    /**
     * <p>One or more events for the endpoint. Valid values are <code>Accept</code>,
     *                 <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.</p>
     */
    ConnectionEvents?: string[];
}
export declare namespace ModifyVpcEndpointConnectionNotificationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcEndpointConnectionNotificationRequest) => any;
}
export interface ModifyVpcEndpointConnectionNotificationResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    ReturnValue?: boolean;
}
export declare namespace ModifyVpcEndpointConnectionNotificationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcEndpointConnectionNotificationResult) => any;
}
export interface ModifyVpcEndpointServiceConfigurationRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the service.</p>
     */
    ServiceId: string | undefined;
    /**
     * <p>(Interface endpoint configuration) The private DNS name to assign to the endpoint service.</p>
     */
    PrivateDnsName?: string;
    /**
     * <p>(Interface endpoint configuration) Removes the private DNS name of the endpoint service.</p>
     */
    RemovePrivateDnsName?: boolean;
    /**
     * <p>Indicates whether requests to create an endpoint to your service must be accepted.</p>
     */
    AcceptanceRequired?: boolean;
    /**
     * <p>The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service
     *             configuration.</p>
     */
    AddNetworkLoadBalancerArns?: string[];
    /**
     * <p>The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service
     *             configuration.</p>
     */
    RemoveNetworkLoadBalancerArns?: string[];
    /**
     * <p>The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service
     *             configuration.</p>
     */
    AddGatewayLoadBalancerArns?: string[];
    /**
     * <p>The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service
     *             configuration.</p>
     */
    RemoveGatewayLoadBalancerArns?: string[];
}
export declare namespace ModifyVpcEndpointServiceConfigurationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcEndpointServiceConfigurationRequest) => any;
}
export interface ModifyVpcEndpointServiceConfigurationResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace ModifyVpcEndpointServiceConfigurationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcEndpointServiceConfigurationResult) => any;
}
export interface ModifyVpcEndpointServicePermissionsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the service.</p>
     */
    ServiceId: string | undefined;
    /**
     * <p>The Amazon Resource Names (ARN) of one or more principals.
     * 	        Permissions are granted to the principals in this list.
     * 	        To grant permissions to all principals, specify an asterisk (*).</p>
     */
    AddAllowedPrincipals?: string[];
    /**
     * <p>The Amazon Resource Names (ARN) of one or more principals.
     * 	        Permissions are revoked for principals in this list.</p>
     */
    RemoveAllowedPrincipals?: string[];
}
export declare namespace ModifyVpcEndpointServicePermissionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcEndpointServicePermissionsRequest) => any;
}
export interface ModifyVpcEndpointServicePermissionsResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    ReturnValue?: boolean;
}
export declare namespace ModifyVpcEndpointServicePermissionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcEndpointServicePermissionsResult) => any;
}
/**
 * <p>The VPC peering connection options.</p>
 */
export interface PeeringConnectionOptionsRequest {
    /**
     * <p>If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.</p>
     */
    AllowDnsResolutionFromRemoteVpc?: boolean;
    /**
     * <p>If true, enables outbound communication from an EC2-Classic instance that's linked to
     *             a local VPC using ClassicLink to instances in a peer VPC.</p>
     */
    AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
    /**
     * <p>If true, enables outbound communication from instances in a local VPC to an
     *             EC2-Classic instance that's linked to a peer VPC using ClassicLink.</p>
     */
    AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export declare namespace PeeringConnectionOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PeeringConnectionOptionsRequest) => any;
}
export interface ModifyVpcPeeringConnectionOptionsRequest {
    /**
     * <p>The VPC peering connection options for the accepter VPC.</p>
     */
    AccepterPeeringConnectionOptions?: PeeringConnectionOptionsRequest;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The VPC peering connection options for the requester VPC.</p>
     */
    RequesterPeeringConnectionOptions?: PeeringConnectionOptionsRequest;
    /**
     * <p>The ID of the VPC peering connection.</p>
     */
    VpcPeeringConnectionId: string | undefined;
}
export declare namespace ModifyVpcPeeringConnectionOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcPeeringConnectionOptionsRequest) => any;
}
/**
 * <p>Describes the VPC peering connection options.</p>
 */
export interface PeeringConnectionOptions {
    /**
     * <p>If true, the public DNS hostnames of instances in the specified VPC resolve to private
     *             IP addresses when queried from instances in the peer VPC.</p>
     */
    AllowDnsResolutionFromRemoteVpc?: boolean;
    /**
     * <p>If true, enables outbound communication from an EC2-Classic instance that's linked to
     *             a local VPC using ClassicLink to instances in a peer VPC.</p>
     */
    AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
    /**
     * <p>If true, enables outbound communication from instances in a local VPC to an
     *             EC2-Classic instance that's linked to a peer VPC using ClassicLink.</p>
     */
    AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export declare namespace PeeringConnectionOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PeeringConnectionOptions) => any;
}
export interface ModifyVpcPeeringConnectionOptionsResult {
    /**
     * <p>Information about the VPC peering connection options for the accepter VPC.</p>
     */
    AccepterPeeringConnectionOptions?: PeeringConnectionOptions;
    /**
     * <p>Information about the VPC peering connection options for the requester VPC.</p>
     */
    RequesterPeeringConnectionOptions?: PeeringConnectionOptions;
}
export declare namespace ModifyVpcPeeringConnectionOptionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcPeeringConnectionOptionsResult) => any;
}
export declare type VpcTenancy = "default";
export interface ModifyVpcTenancyRequest {
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
    /**
     * <p>The instance tenancy attribute for the VPC. </p>
     */
    InstanceTenancy: VpcTenancy | string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyVpcTenancyRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcTenancyRequest) => any;
}
export interface ModifyVpcTenancyResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, returns an
     *             error.</p>
     */
    ReturnValue?: boolean;
}
export declare namespace ModifyVpcTenancyResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpcTenancyResult) => any;
}
export interface ModifyVpnConnectionRequest {
    /**
     * <p>The ID of the VPN connection.</p>
     */
    VpnConnectionId: string | undefined;
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId?: string;
    /**
     * <p>The ID of the customer gateway at your end of the VPN connection.</p>
     */
    CustomerGatewayId?: string;
    /**
     * <p>The ID of the virtual private gateway at the Amazon Web Services side of the VPN
     *             connection.</p>
     */
    VpnGatewayId?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyVpnConnectionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpnConnectionRequest) => any;
}
export interface ModifyVpnConnectionResult {
    /**
     * <p>Describes a VPN connection.</p>
     */
    VpnConnection?: VpnConnection;
}
export declare namespace ModifyVpnConnectionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpnConnectionResult) => any;
}
export interface ModifyVpnConnectionOptionsRequest {
    /**
     * <p>The ID of the Site-to-Site VPN connection. </p>
     */
    VpnConnectionId: string | undefined;
    /**
     * <p>The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     *         <p>Default: <code>0.0.0.0/0</code>
     *          </p>
     */
    LocalIpv4NetworkCidr?: string;
    /**
     * <p>The IPv4 CIDR on the Amazon Web Services side of the VPN connection.</p>
     *         <p>Default: <code>0.0.0.0/0</code>
     *          </p>
     */
    RemoteIpv4NetworkCidr?: string;
    /**
     * <p>The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     *         <p>Default: <code>::/0</code>
     *          </p>
     */
    LocalIpv6NetworkCidr?: string;
    /**
     * <p>The IPv6 CIDR on the Amazon Web Services side of the VPN connection.</p>
     *         <p>Default: <code>::/0</code>
     *          </p>
     */
    RemoteIpv6NetworkCidr?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyVpnConnectionOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpnConnectionOptionsRequest) => any;
}
export interface ModifyVpnConnectionOptionsResult {
    /**
     * <p>Describes a VPN connection.</p>
     */
    VpnConnection?: VpnConnection;
}
export declare namespace ModifyVpnConnectionOptionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpnConnectionOptionsResult) => any;
}
export interface ModifyVpnTunnelCertificateRequest {
    /**
     * <p>The ID of the Amazon Web Services Site-to-Site VPN connection.</p>
     */
    VpnConnectionId: string | undefined;
    /**
     * <p>The external IP address of the VPN tunnel.</p>
     */
    VpnTunnelOutsideIpAddress: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyVpnTunnelCertificateRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpnTunnelCertificateRequest) => any;
}
export interface ModifyVpnTunnelCertificateResult {
    /**
     * <p>Describes a VPN connection.</p>
     */
    VpnConnection?: VpnConnection;
}
export declare namespace ModifyVpnTunnelCertificateResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpnTunnelCertificateResult) => any;
}
/**
 * <p>The Amazon Web Services Site-to-Site VPN tunnel options to modify.</p>
 */
export interface ModifyVpnTunnelOptionsSpecification {
    /**
     * <p>The range of inside IPv4 addresses for the tunnel. Any specified CIDR blocks must be
     *             unique across all VPN connections that use the same virtual private gateway. </p>
     *         <p>Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The
     *             following CIDR blocks are reserved and cannot be used:</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>169.254.0.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.1.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.2.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.3.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.4.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.5.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.169.252/30</code>
     *                </p>
     *             </li>
     *          </ul>
     */
    TunnelInsideCidr?: string;
    /**
     * <p>The range of inside IPv6 addresses for the tunnel. Any specified CIDR blocks must be
     *             unique across all VPN connections that use the same transit gateway.</p>
     *         <p>Constraints: A size /126 CIDR block from the local <code>fd00::/8</code> range.</p>
     */
    TunnelInsideIpv6Cidr?: string;
    /**
     * <p>The pre-shared key (PSK) to establish initial authentication between the virtual
     *             private gateway and the customer gateway.</p>
     *         <p>Constraints: Allowed characters are alphanumeric characters, periods (.), and
     *             underscores (_). Must be between 8 and 64 characters in length and cannot start with
     *             zero (0).</p>
     */
    PreSharedKey?: string;
    /**
     * <p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p>
     *         <p>Constraints: A value between 900 and 28,800.</p>
     *         <p>Default: <code>28800</code>
     *          </p>
     */
    Phase1LifetimeSeconds?: number;
    /**
     * <p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p>
     *         <p>Constraints: A value between 900 and 3,600. The value must be less than the value for
     *                 <code>Phase1LifetimeSeconds</code>.</p>
     *         <p>Default: <code>3600</code>
     *          </p>
     */
    Phase2LifetimeSeconds?: number;
    /**
     * <p>The margin time, in seconds, before the phase 2 lifetime expires, during which the
     *                 Amazon Web Services side of the VPN connection performs an IKE rekey. The exact time
     *             of the rekey is randomly selected based on the value for
     *                 <code>RekeyFuzzPercentage</code>.</p>
     *         <p>Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code>.</p>
     *         <p>Default: <code>540</code>
     *          </p>
     */
    RekeyMarginTimeSeconds?: number;
    /**
     * <p>The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code>)
     *             during which the rekey time is randomly selected.</p>
     *         <p>Constraints: A value between 0 and 100.</p>
     *         <p>Default: <code>100</code>
     *          </p>
     */
    RekeyFuzzPercentage?: number;
    /**
     * <p>The number of packets in an IKE replay window.</p>
     *         <p>Constraints: A value between 64 and 2048.</p>
     *         <p>Default: <code>1024</code>
     *          </p>
     */
    ReplayWindowSize?: number;
    /**
     * <p>The number of seconds after which a DPD timeout occurs.</p>
     *         <p>Constraints: A value between 0 and 30.</p>
     *         <p>Default: <code>30</code>
     *          </p>
     */
    DPDTimeoutSeconds?: number;
    /**
     * <p>The action to take after DPD timeout occurs. Specify <code>restart</code> to restart
     *             the IKE initiation. Specify <code>clear</code> to end the IKE session.</p>
     *         <p>Valid Values: <code>clear</code> | <code>none</code> | <code>restart</code>
     *          </p>
     *         <p>Default: <code>clear</code>
     *          </p>
     */
    DPDTimeoutAction?: string;
    /**
     * <p>One or more encryption algorithms that are permitted for the VPN tunnel for phase 1
     *             IKE negotiations.</p>
     *         <p>Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
     *                 <code>AES256-GCM-16</code>
     *          </p>
     */
    Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsRequestListValue[];
    /**
     * <p>One or more encryption algorithms that are permitted for the VPN tunnel for phase 2
     *             IKE negotiations.</p>
     *         <p>Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
     *                 <code>AES256-GCM-16</code>
     *          </p>
     */
    Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsRequestListValue[];
    /**
     * <p>One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE
     *             negotiations.</p>
     *         <p>Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> |
     *                 <code>SHA2-512</code>
     *          </p>
     */
    Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsRequestListValue[];
    /**
     * <p>One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE
     *             negotiations.</p>
     *         <p>Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> |
     *                 <code>SHA2-512</code>
     *          </p>
     */
    Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsRequestListValue[];
    /**
     * <p>One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for
     *             phase 1 IKE negotiations.</p>
     *         <p>Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> |
     *                 <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> |
     *                 <code>21</code> | <code>22</code> | <code>23</code> | <code>24</code>
     *          </p>
     */
    Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[];
    /**
     * <p>One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for
     *             phase 2 IKE negotiations.</p>
     *         <p>Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> |
     *                 <code>16</code> | <code>17</code> | <code>18</code> | <code>19</code> |
     *                 <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> |
     *                 <code>24</code>
     *          </p>
     */
    Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[];
    /**
     * <p>The IKE versions that are permitted for the VPN tunnel.</p>
     *         <p>Valid values: <code>ikev1</code> | <code>ikev2</code>
     *          </p>
     */
    IKEVersions?: IKEVersionsRequestListValue[];
    /**
     * <p>The action to take when the establishing the tunnel for the VPN connection. By
     *             default, your customer gateway device must initiate the IKE negotiation and bring up the
     *             tunnel. Specify <code>start</code> for Amazon Web Services to initiate the IKE
     *             negotiation.</p>
     *         <p>Valid Values: <code>add</code> | <code>start</code>
     *          </p>
     *         <p>Default: <code>add</code>
     *          </p>
     */
    StartupAction?: string;
}
export declare namespace ModifyVpnTunnelOptionsSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpnTunnelOptionsSpecification) => any;
}
export interface ModifyVpnTunnelOptionsRequest {
    /**
     * <p>The ID of the Amazon Web Services Site-to-Site VPN connection.</p>
     */
    VpnConnectionId: string | undefined;
    /**
     * <p>The external IP address of the VPN tunnel.</p>
     */
    VpnTunnelOutsideIpAddress: string | undefined;
    /**
     * <p>The tunnel options to modify.</p>
     */
    TunnelOptions: ModifyVpnTunnelOptionsSpecification | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ModifyVpnTunnelOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpnTunnelOptionsRequest) => any;
}
export interface ModifyVpnTunnelOptionsResult {
    /**
     * <p>Describes a VPN connection.</p>
     */
    VpnConnection?: VpnConnection;
}
export declare namespace ModifyVpnTunnelOptionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ModifyVpnTunnelOptionsResult) => any;
}
export interface MonitorInstancesRequest {
    /**
     * <p>The IDs of the instances.</p>
     */
    InstanceIds: string[] | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace MonitorInstancesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: MonitorInstancesRequest) => any;
}
/**
 * <p>Describes the monitoring of an instance.</p>
 */
export interface InstanceMonitoring {
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
    /**
     * <p>The monitoring for the instance.</p>
     */
    Monitoring?: Monitoring;
}
export declare namespace InstanceMonitoring {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceMonitoring) => any;
}
export interface MonitorInstancesResult {
    /**
     * <p>The monitoring information.</p>
     */
    InstanceMonitorings?: InstanceMonitoring[];
}
export declare namespace MonitorInstancesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: MonitorInstancesResult) => any;
}
export interface MoveAddressToVpcRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The Elastic IP address.</p>
     */
    PublicIp: string | undefined;
}
export declare namespace MoveAddressToVpcRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: MoveAddressToVpcRequest) => any;
}
export declare enum Status {
    inClassic = "InClassic",
    inVpc = "InVpc",
    moveInProgress = "MoveInProgress"
}
export interface MoveAddressToVpcResult {
    /**
     * <p>The allocation ID for the Elastic IP address.</p>
     */
    AllocationId?: string;
    /**
     * <p>The status of the move of the IP address.</p>
     */
    Status?: Status | string;
}
export declare namespace MoveAddressToVpcResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: MoveAddressToVpcResult) => any;
}
export interface MoveByoipCidrToIpamRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The BYOIP CIDR.</p>
     */
    Cidr?: string;
    /**
     * <p>The IPAM pool ID.</p>
     */
    IpamPoolId?: string;
    /**
     * <p>The Amazon Web Services account ID of the owner of the IPAM pool.</p>
     */
    IpamPoolOwner?: string;
}
export declare namespace MoveByoipCidrToIpamRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: MoveByoipCidrToIpamRequest) => any;
}
export interface MoveByoipCidrToIpamResult {
    /**
     * <p>Information about an address range that is provisioned for use with your Amazon Web Services resources
     *          through bring your own IP addresses (BYOIP).</p>
     */
    ByoipCidr?: ByoipCidr;
}
export declare namespace MoveByoipCidrToIpamResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: MoveByoipCidrToIpamResult) => any;
}
/**
 * <p>Provides authorization for Amazon to bring a specific IP address range to a specific
 *           Amazon Web Services account using bring your own IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip">Configuring your BYOIP address range</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
 */
export interface CidrAuthorizationContext {
    /**
     * <p>The plain-text authorization message for the prefix and account.</p>
     */
    Message: string | undefined;
    /**
     * <p>The signed authorization message for the prefix and account.</p>
     */
    Signature: string | undefined;
}
export declare namespace CidrAuthorizationContext {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CidrAuthorizationContext) => any;
}
export interface ProvisionByoipCidrRequest {
    /**
     * <p>The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can
     *          specify is /24. The most specific IPv6 prefix you can specify is /56. The address range cannot overlap with another address range that you've
     *          brought to this or another Region.</p>
     */
    Cidr: string | undefined;
    /**
     * <p>A signed document that proves that you are authorized to bring the specified IP address
     *          range to Amazon using BYOIP.</p>
     */
    CidrAuthorizationContext?: CidrAuthorizationContext;
    /**
     * <p>(IPv6 only) Indicate whether the address range will be publicly advertised to the
     *             internet.</p>
     *         <p>Default: true</p>
     */
    PubliclyAdvertisable?: boolean;
    /**
     * <p>A description for the address range and the address pool.</p>
     */
    Description?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The tags to apply to the address pool.</p>
     */
    PoolTagSpecifications?: TagSpecification[];
    /**
     * <p>Reserved.</p>
     */
    MultiRegion?: boolean;
}
export declare namespace ProvisionByoipCidrRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ProvisionByoipCidrRequest) => any;
}
export interface ProvisionByoipCidrResult {
    /**
     * <p>Information about the address range.</p>
     */
    ByoipCidr?: ByoipCidr;
}
export declare namespace ProvisionByoipCidrResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ProvisionByoipCidrResult) => any;
}
/**
 * <p>A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP.</p>
 */
export interface IpamCidrAuthorizationContext {
    /**
     * <p>The plain-text authorization message for the prefix and account.</p>
     */
    Message?: string;
    /**
     * <p>The signed authorization message for the prefix and account.</p>
     */
    Signature?: string;
}
export declare namespace IpamCidrAuthorizationContext {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: IpamCidrAuthorizationContext) => any;
}
export interface ProvisionIpamPoolCidrRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the IPAM pool to which you want to assign a CIDR.</p>
     */
    IpamPoolId: string | undefined;
    /**
     * <p>The CIDR you want to assign to the IPAM pool.</p>
     */
    Cidr?: string;
    /**
     * <p>A signed document that proves that you are authorized to bring a specified IP address range to Amazon using BYOIP. This option applies to public pools only.</p>
     */
    CidrAuthorizationContext?: IpamCidrAuthorizationContext;
}
export declare namespace ProvisionIpamPoolCidrRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ProvisionIpamPoolCidrRequest) => any;
}
export interface ProvisionIpamPoolCidrResult {
    /**
     * <p>Information about the provisioned CIDR.</p>
     */
    IpamPoolCidr?: IpamPoolCidr;
}
export declare namespace ProvisionIpamPoolCidrResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ProvisionIpamPoolCidrResult) => any;
}
export interface ProvisionPublicIpv4PoolCidrRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the IPAM pool you would like to use to allocate this CIDR.</p>
     */
    IpamPoolId: string | undefined;
    /**
     * <p>The ID of the public IPv4 pool you would like to use for this CIDR.</p>
     */
    PoolId: string | undefined;
    /**
     * <p>The netmask length of the CIDR you would like to allocate to the public IPv4 pool.</p>
     */
    NetmaskLength: number | undefined;
}
export declare namespace ProvisionPublicIpv4PoolCidrRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ProvisionPublicIpv4PoolCidrRequest) => any;
}
export interface ProvisionPublicIpv4PoolCidrResult {
    /**
     * <p>The ID of the pool that you want to provision the CIDR to.</p>
     */
    PoolId?: string;
    /**
     * <p>Describes an address range of an IPv4 address pool.</p>
     */
    PoolAddressRange?: PublicIpv4PoolRange;
}
export declare namespace ProvisionPublicIpv4PoolCidrResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ProvisionPublicIpv4PoolCidrResult) => any;
}
export interface PurchaseHostReservationRequest {
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     */
    ClientToken?: string;
    /**
     * <p>The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>,
     *             and <code>totalHourlyPrice</code> amounts are specified. At this time, the only
     *             supported currency is <code>USD</code>.</p>
     */
    CurrencyCode?: CurrencyCodeValues | string;
    /**
     * <p>The IDs of the Dedicated Hosts with which the reservation will be associated.</p>
     */
    HostIdSet: string[] | undefined;
    /**
     * <p>The specified limit is checked against the total upfront cost of the reservation
     *             (calculated as the offering's upfront cost multiplied by the host count). If the total
     *             upfront cost is greater than the specified price limit, the request fails. This is used
     *             to ensure that the purchase does not exceed the expected upfront cost of the purchase.
     *             At this time, the only supported currency is <code>USD</code>. For example, to indicate
     *             a limit price of USD 100, specify 100.00.</p>
     */
    LimitPrice?: string;
    /**
     * <p>The ID of the offering.</p>
     */
    OfferingId: string | undefined;
    /**
     * <p>The tags to apply to the Dedicated Host Reservation during purchase.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace PurchaseHostReservationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PurchaseHostReservationRequest) => any;
}
export interface PurchaseHostReservationResult {
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     */
    ClientToken?: string;
    /**
     * <p>The currency in which the <code>totalUpfrontPrice</code> and
     *                 <code>totalHourlyPrice</code> amounts are specified. At this time, the only
     *             supported currency is <code>USD</code>.</p>
     */
    CurrencyCode?: CurrencyCodeValues | string;
    /**
     * <p>Describes the details of the purchase.</p>
     */
    Purchase?: Purchase[];
    /**
     * <p>The total hourly price of the reservation calculated per hour.</p>
     */
    TotalHourlyPrice?: string;
    /**
     * <p>The total amount charged to your account when you purchase the reservation.</p>
     */
    TotalUpfrontPrice?: string;
}
export declare namespace PurchaseHostReservationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PurchaseHostReservationResult) => any;
}
/**
 * <p>Describes the limit price of a Reserved Instance offering.</p>
 */
export interface ReservedInstanceLimitPrice {
    /**
     * <p>Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order (instanceCount * price).</p>
     */
    Amount?: number;
    /**
     * <p>The currency in which the <code>limitPrice</code> amount is specified.
     * 				At this time, the only supported currency is <code>USD</code>.</p>
     */
    CurrencyCode?: CurrencyCodeValues | string;
}
export declare namespace ReservedInstanceLimitPrice {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReservedInstanceLimitPrice) => any;
}
/**
 * <p>Contains the parameters for PurchaseReservedInstancesOffering.</p>
 */
export interface PurchaseReservedInstancesOfferingRequest {
    /**
     * <p>The number of Reserved Instances to purchase.</p>
     */
    InstanceCount: number | undefined;
    /**
     * <p>The ID of the Reserved Instance offering to purchase.</p>
     */
    ReservedInstancesOfferingId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *        and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *        Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved Instances are not purchased at unexpected prices.</p>
     */
    LimitPrice?: ReservedInstanceLimitPrice;
    /**
     * <p>The time at which to purchase the Reserved Instance, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     */
    PurchaseTime?: Date;
}
export declare namespace PurchaseReservedInstancesOfferingRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PurchaseReservedInstancesOfferingRequest) => any;
}
/**
 * <p>Contains the output of PurchaseReservedInstancesOffering.</p>
 */
export interface PurchaseReservedInstancesOfferingResult {
    /**
     * <p>The IDs of the purchased Reserved Instances. If your purchase crosses into a discounted
     *       pricing tier, the final Reserved Instances IDs might change. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-reserved-instances-application.html#crossing-pricing-tiers">Crossing
     *         pricing tiers</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     */
    ReservedInstancesId?: string;
}
export declare namespace PurchaseReservedInstancesOfferingResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PurchaseReservedInstancesOfferingResult) => any;
}
/**
 * <p>Describes a request to purchase Scheduled Instances.</p>
 */
export interface PurchaseRequest {
    /**
     * <p>The number of instances.</p>
     */
    InstanceCount: number | undefined;
    /**
     * <p>The purchase token.</p>
     */
    PurchaseToken: string | undefined;
}
export declare namespace PurchaseRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PurchaseRequest) => any;
}
/**
 * <p>Contains the parameters for PurchaseScheduledInstances.</p>
 */
export interface PurchaseScheduledInstancesRequest {
    /**
     * <p>Unique, case-sensitive identifier that ensures the idempotency of the request.
     *          For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     */
    ClientToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The purchase requests.</p>
     */
    PurchaseRequests: PurchaseRequest[] | undefined;
}
export declare namespace PurchaseScheduledInstancesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PurchaseScheduledInstancesRequest) => any;
}
/**
 * <p>Contains the output of PurchaseScheduledInstances.</p>
 */
export interface PurchaseScheduledInstancesResult {
    /**
     * <p>Information about the Scheduled Instances.</p>
     */
    ScheduledInstanceSet?: ScheduledInstance[];
}
export declare namespace PurchaseScheduledInstancesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PurchaseScheduledInstancesResult) => any;
}
export interface RebootInstancesRequest {
    /**
     * <p>The instance IDs.</p>
     */
    InstanceIds: string[] | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace RebootInstancesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RebootInstancesRequest) => any;
}
/**
 * <p>Contains the parameters for RegisterImage.</p>
 */
export interface RegisterImageRequest {
    /**
     * <p>The full path to your AMI manifest in Amazon S3 storage. The specified bucket must have the
     *    		<code>aws-exec-read</code> canned access control list (ACL) to ensure that it can be accessed
     *    		by Amazon EC2. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACLs</a> in the
     *    		<i>Amazon S3 Service Developer Guide</i>.</p>
     */
    ImageLocation?: string;
    /**
     * <p>The architecture of the AMI.</p>
     *    	     <p>Default: For Amazon EBS-backed AMIs, <code>i386</code>.
     *         For instance store-backed AMIs, the architecture specified in the manifest file.</p>
     */
    Architecture?: ArchitectureValues | string;
    /**
     * <p>The block device mapping entries.</p>
     *    	     <p>If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can't specify the encryption state of the volume.</p>
     *          <p>If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region
     *     	 of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same Outpost
     *     	 only. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
     *     	 	Amazon EBS local snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     */
    BlockDeviceMappings?: BlockDeviceMapping[];
    /**
     * <p>A description for your AMI.</p>
     */
    Description?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *        and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *        Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you launch from the AMI.</p>
     *          <p>This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.</p>
     */
    EnaSupport?: boolean;
    /**
     * <p>The ID of the kernel.</p>
     */
    KernelId?: string;
    /**
     * <p>A name for your AMI.</p>
     *          <p>Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)</p>
     */
    Name: string | undefined;
    /**
     * <p>The billing product codes. Your account must be authorized to specify billing product codes. Otherwise,
     *      	you can use the Amazon Web Services Marketplace to bill for the use of an AMI.</p>
     */
    BillingProducts?: string[];
    /**
     * <p>The ID of the RAM disk.</p>
     */
    RamdiskId?: string;
    /**
     * <p>The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>
     */
    RootDeviceName?: string;
    /**
     * <p>Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for the AMI and any instances that you launch from the AMI.</p>
     *          <p>There is no way to disable <code>sriovNetSupport</code> at this time.</p>
     *          <p>This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.</p>
     */
    SriovNetSupport?: string;
    /**
     * <p>The type of virtualization (<code>hvm</code> | <code>paravirtual</code>).</p>
     *          <p>Default: <code>paravirtual</code>
     *          </p>
     */
    VirtualizationType?: string;
    /**
     * <p>The boot mode of the AMI. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     */
    BootMode?: BootModeValues | string;
}
export declare namespace RegisterImageRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RegisterImageRequest) => any;
}
/**
 * <p>Contains the output of RegisterImage.</p>
 */
export interface RegisterImageResult {
    /**
     * <p>The ID of the newly registered AMI.</p>
     */
    ImageId?: string;
}
export declare namespace RegisterImageResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RegisterImageResult) => any;
}
/**
 * <p>Information about the tag keys to register for the current Region. You can either specify
 *       	individual tag keys or register all tag keys in the current Region. You must specify either
 *       	<code>IncludeAllTagsOfInstance</code> or <code>InstanceTagKeys</code> in the request</p>
 */
export interface RegisterInstanceTagAttributeRequest {
    /**
     * <p>Indicates whether to register all tag keys in the current Region. Specify <code>true</code>
     *       	to register all tag keys.</p>
     */
    IncludeAllTagsOfInstance?: boolean;
    /**
     * <p>The tag keys to register.</p>
     */
    InstanceTagKeys?: string[];
}
export declare namespace RegisterInstanceTagAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RegisterInstanceTagAttributeRequest) => any;
}
export interface RegisterInstanceEventNotificationAttributesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Information about the tag keys to register.</p>
     */
    InstanceTagAttribute?: RegisterInstanceTagAttributeRequest;
}
export declare namespace RegisterInstanceEventNotificationAttributesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RegisterInstanceEventNotificationAttributesRequest) => any;
}
export interface RegisterInstanceEventNotificationAttributesResult {
    /**
     * <p>The resulting set of tag keys.</p>
     */
    InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export declare namespace RegisterInstanceEventNotificationAttributesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RegisterInstanceEventNotificationAttributesResult) => any;
}
export interface RegisterTransitGatewayMulticastGroupMembersRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     */
    GroupIpAddress?: string;
    /**
     * <p>The group members' network interface IDs to register with the  transit gateway multicast group.</p>
     */
    NetworkInterfaceIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace RegisterTransitGatewayMulticastGroupMembersRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RegisterTransitGatewayMulticastGroupMembersRequest) => any;
}
/**
 * <p>Describes the registered  transit gateway multicast group members.</p>
 */
export interface TransitGatewayMulticastRegisteredGroupMembers {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The ID of the registered network interfaces.</p>
     */
    RegisteredNetworkInterfaceIds?: string[];
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     */
    GroupIpAddress?: string;
}
export declare namespace TransitGatewayMulticastRegisteredGroupMembers {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayMulticastRegisteredGroupMembers) => any;
}
export interface RegisterTransitGatewayMulticastGroupMembersResult {
    /**
     * <p>Information about the registered  transit gateway multicast group members.</p>
     */
    RegisteredMulticastGroupMembers?: TransitGatewayMulticastRegisteredGroupMembers;
}
export declare namespace RegisterTransitGatewayMulticastGroupMembersResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RegisterTransitGatewayMulticastGroupMembersResult) => any;
}
export interface RegisterTransitGatewayMulticastGroupSourcesRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     */
    GroupIpAddress?: string;
    /**
     * <p>The group sources' network interface IDs to register with the  transit gateway multicast group.</p>
     */
    NetworkInterfaceIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace RegisterTransitGatewayMulticastGroupSourcesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RegisterTransitGatewayMulticastGroupSourcesRequest) => any;
}
/**
 * <p>Describes the members registered with the  transit gateway multicast group.</p>
 */
export interface TransitGatewayMulticastRegisteredGroupSources {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The IDs of the network interfaces members registered with the  transit gateway multicast group.</p>
     */
    RegisteredNetworkInterfaceIds?: string[];
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     */
    GroupIpAddress?: string;
}
export declare namespace TransitGatewayMulticastRegisteredGroupSources {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayMulticastRegisteredGroupSources) => any;
}
export interface RegisterTransitGatewayMulticastGroupSourcesResult {
    /**
     * <p>Information about the  transit gateway multicast group sources.</p>
     */
    RegisteredMulticastGroupSources?: TransitGatewayMulticastRegisteredGroupSources;
}
export declare namespace RegisterTransitGatewayMulticastGroupSourcesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RegisterTransitGatewayMulticastGroupSourcesResult) => any;
}
export interface RejectTransitGatewayMulticastDomainAssociationsRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The ID of the transit gateway attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
     */
    SubnetIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace RejectTransitGatewayMulticastDomainAssociationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectTransitGatewayMulticastDomainAssociationsRequest) => any;
}
export interface RejectTransitGatewayMulticastDomainAssociationsResult {
    /**
     * <p>Describes the multicast domain associations.</p>
     */
    Associations?: TransitGatewayMulticastDomainAssociations;
}
export declare namespace RejectTransitGatewayMulticastDomainAssociationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectTransitGatewayMulticastDomainAssociationsResult) => any;
}
export interface RejectTransitGatewayPeeringAttachmentRequest {
    /**
     * <p>The ID of the transit gateway peering attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace RejectTransitGatewayPeeringAttachmentRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectTransitGatewayPeeringAttachmentRequest) => any;
}
export interface RejectTransitGatewayPeeringAttachmentResult {
    /**
     * <p>The transit gateway peering attachment.</p>
     */
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export declare namespace RejectTransitGatewayPeeringAttachmentResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectTransitGatewayPeeringAttachmentResult) => any;
}
export interface RejectTransitGatewayVpcAttachmentRequest {
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace RejectTransitGatewayVpcAttachmentRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectTransitGatewayVpcAttachmentRequest) => any;
}
export interface RejectTransitGatewayVpcAttachmentResult {
    /**
     * <p>Information about the attachment.</p>
     */
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare namespace RejectTransitGatewayVpcAttachmentResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectTransitGatewayVpcAttachmentResult) => any;
}
export interface RejectVpcEndpointConnectionsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the service.</p>
     */
    ServiceId: string | undefined;
    /**
     * <p>The IDs of one or more VPC endpoints.</p>
     */
    VpcEndpointIds: string[] | undefined;
}
export declare namespace RejectVpcEndpointConnectionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectVpcEndpointConnectionsRequest) => any;
}
export interface RejectVpcEndpointConnectionsResult {
    /**
     * <p>Information about the endpoints that were not rejected, if applicable.</p>
     */
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace RejectVpcEndpointConnectionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectVpcEndpointConnectionsResult) => any;
}
export interface RejectVpcPeeringConnectionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the VPC peering connection.</p>
     */
    VpcPeeringConnectionId: string | undefined;
}
export declare namespace RejectVpcPeeringConnectionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectVpcPeeringConnectionRequest) => any;
}
export interface RejectVpcPeeringConnectionResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace RejectVpcPeeringConnectionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RejectVpcPeeringConnectionResult) => any;
}
export interface ReleaseAddressRequest {
    /**
     * <p>[EC2-VPC] The allocation ID. Required for EC2-VPC.</p>
     */
    AllocationId?: string;
    /**
     * <p>[EC2-Classic] The Elastic IP address. Required for EC2-Classic.</p>
     */
    PublicIp?: string;
    /**
     * <p>The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises
     *       IP addresses.</p>
     *          <p>If you provide an incorrect network border group, you receive an <code>InvalidAddress.NotFound</code> error.</p>
     *          <p>You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 classic, you
     *       receive an <code>InvalidParameterCombination</code> error.</p>
     */
    NetworkBorderGroup?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ReleaseAddressRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReleaseAddressRequest) => any;
}
export interface ReleaseHostsRequest {
    /**
     * <p>The IDs of the Dedicated Hosts to release.</p>
     */
    HostIds: string[] | undefined;
}
export declare namespace ReleaseHostsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReleaseHostsRequest) => any;
}
export interface ReleaseHostsResult {
    /**
     * <p>The IDs of the Dedicated Hosts that were successfully released.</p>
     */
    Successful?: string[];
    /**
     * <p>The IDs of the Dedicated Hosts that could not be released, including an error
     *             message.</p>
     */
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace ReleaseHostsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReleaseHostsResult) => any;
}
export interface ReleaseIpamPoolAllocationRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the IPAM pool which contains the allocation you want to release.</p>
     */
    IpamPoolId: string | undefined;
    /**
     * <p>The CIDR of the allocation you want to release.</p>
     */
    Cidr: string | undefined;
    /**
     * <p>The ID of the allocation.</p>
     */
    IpamPoolAllocationId?: string;
}
export declare namespace ReleaseIpamPoolAllocationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReleaseIpamPoolAllocationRequest) => any;
}
export interface ReleaseIpamPoolAllocationResult {
    /**
     * <p>Indicates if the release was successful.</p>
     */
    Success?: boolean;
}
export declare namespace ReleaseIpamPoolAllocationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReleaseIpamPoolAllocationResult) => any;
}
export interface ReplaceIamInstanceProfileAssociationRequest {
    /**
     * <p>The IAM instance profile.</p>
     */
    IamInstanceProfile: IamInstanceProfileSpecification | undefined;
    /**
     * <p>The ID of the existing IAM instance profile association.</p>
     */
    AssociationId: string | undefined;
}
export declare namespace ReplaceIamInstanceProfileAssociationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceIamInstanceProfileAssociationRequest) => any;
}
export interface ReplaceIamInstanceProfileAssociationResult {
    /**
     * <p>Information about the IAM instance profile association.</p>
     */
    IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export declare namespace ReplaceIamInstanceProfileAssociationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceIamInstanceProfileAssociationResult) => any;
}
export interface ReplaceNetworkAclAssociationRequest {
    /**
     * <p>The ID of the current association between the original network ACL and the subnet.</p>
     */
    AssociationId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the new network ACL to associate with the subnet.</p>
     */
    NetworkAclId: string | undefined;
}
export declare namespace ReplaceNetworkAclAssociationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceNetworkAclAssociationRequest) => any;
}
export interface ReplaceNetworkAclAssociationResult {
    /**
     * <p>The ID of the new association.</p>
     */
    NewAssociationId?: string;
}
export declare namespace ReplaceNetworkAclAssociationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceNetworkAclAssociationResult) => any;
}
export interface ReplaceNetworkAclEntryRequest {
    /**
     * <p>The IPv4 network range to allow or deny, in CIDR notation (for example
     *                 <code>172.16.0.0/24</code>).</p>
     */
    CidrBlock?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Indicates whether to replace the egress rule.</p>
     * 		       <p>Default: If no value is specified, we replace the ingress rule.</p>
     */
    Egress: boolean | undefined;
    /**
     * <p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol
     * 		        1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>
     */
    IcmpTypeCode?: IcmpTypeCode;
    /**
     * <p>The IPv6 network range to allow or deny, in CIDR notation (for example
     *                 <code>2001:bd8:1234:1a00::/64</code>).</p>
     */
    Ipv6CidrBlock?: string;
    /**
     * <p>The ID of the ACL.</p>
     */
    NetworkAclId: string | undefined;
    /**
     * <p>TCP or UDP protocols: The range of ports the rule applies to.
     * 		        Required if specifying protocol 6 (TCP) or 17 (UDP).</p>
     */
    PortRange?: PortRange;
    /**
     * <p>The protocol number. A value of "-1" means all protocols. If you specify "-1" or a
     *            protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is
     *            allowed, regardless of any ports or ICMP types or codes that you specify. If you specify
     *            protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and
     *            codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6)
     *            and specify an IPv6 CIDR block, you must specify an ICMP type and code.</p>
     */
    Protocol: string | undefined;
    /**
     * <p>Indicates whether to allow or deny the traffic that matches the rule.</p>
     */
    RuleAction: RuleAction | string | undefined;
    /**
     * <p>The rule number of the entry to replace.</p>
     */
    RuleNumber: number | undefined;
}
export declare namespace ReplaceNetworkAclEntryRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceNetworkAclEntryRequest) => any;
}
export interface ReplaceRouteRequest {
    /**
     * <p>The IPv4 CIDR address block used for the destination match. The value that you
     * 			provide must match the CIDR of an existing route in the table.</p>
     */
    DestinationCidrBlock?: string;
    /**
     * <p>The IPv6 CIDR address block used for the destination match. The value that you
     * 			provide must match the CIDR of an existing route in the table.</p>
     */
    DestinationIpv6CidrBlock?: string;
    /**
     * <p>The ID of the prefix list for the route.</p>
     */
    DestinationPrefixListId?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
     */
    VpcEndpointId?: string;
    /**
     * <p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>
     */
    EgressOnlyInternetGatewayId?: string;
    /**
     * <p>The ID of an internet gateway or virtual private gateway.</p>
     */
    GatewayId?: string;
    /**
     * <p>The ID of a NAT instance in your VPC.</p>
     */
    InstanceId?: string;
    /**
     * <p>Specifies whether to reset the local route to its default target (<code>local</code>).</p>
     */
    LocalTarget?: boolean;
    /**
     * <p>[IPv4 traffic only] The ID of a NAT gateway.</p>
     */
    NatGatewayId?: string;
    /**
     * <p>The ID of a transit gateway.</p>
     */
    TransitGatewayId?: string;
    /**
     * <p>The ID of the local gateway.</p>
     */
    LocalGatewayId?: string;
    /**
     * <p>[IPv4 traffic only] The ID of a carrier gateway.</p>
     */
    CarrierGatewayId?: string;
    /**
     * <p>The ID of a network interface.</p>
     */
    NetworkInterfaceId?: string;
    /**
     * <p>The ID of the route table.</p>
     */
    RouteTableId: string | undefined;
    /**
     * <p>The ID of a VPC peering connection.</p>
     */
    VpcPeeringConnectionId?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of the core network.</p>
     */
    CoreNetworkArn?: string;
}
export declare namespace ReplaceRouteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceRouteRequest) => any;
}
export interface ReplaceRouteTableAssociationRequest {
    /**
     * <p>The association ID.</p>
     */
    AssociationId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the new route table to associate with the subnet.</p>
     */
    RouteTableId: string | undefined;
}
export declare namespace ReplaceRouteTableAssociationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceRouteTableAssociationRequest) => any;
}
export interface ReplaceRouteTableAssociationResult {
    /**
     * <p>The ID of the new association.</p>
     */
    NewAssociationId?: string;
    /**
     * <p>The state of the association.</p>
     */
    AssociationState?: RouteTableAssociationState;
}
export declare namespace ReplaceRouteTableAssociationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceRouteTableAssociationResult) => any;
}
export interface ReplaceTransitGatewayRouteRequest {
    /**
     * <p>The CIDR range used for the destination match. Routing decisions are based on the most specific match.</p>
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>The ID of the route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>Indicates whether traffic matching this route is to be dropped.</p>
     */
    Blackhole?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ReplaceTransitGatewayRouteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceTransitGatewayRouteRequest) => any;
}
export interface ReplaceTransitGatewayRouteResult {
    /**
     * <p>Information about the modified route.</p>
     */
    Route?: TransitGatewayRoute;
}
export declare namespace ReplaceTransitGatewayRouteResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReplaceTransitGatewayRouteResult) => any;
}
export declare type ReportInstanceReasonCodes = "instance-stuck-in-state" | "not-accepting-credentials" | "other" | "password-not-available" | "performance-ebs-volume" | "performance-instance-store" | "performance-network" | "performance-other" | "unresponsive";
export declare type ReportStatusType = "impaired" | "ok";
export interface ReportInstanceStatusRequest {
    /**
     * <p>Descriptive text about the health state of your instance.</p>
     */
    Description?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The time at which the reported instance health state ended.</p>
     */
    EndTime?: Date;
    /**
     * <p>The instances.</p>
     */
    Instances: string[] | undefined;
    /**
     * <p>The reason codes that describe the health state of your instance.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                     <code>instance-stuck-in-state</code>: My instance is stuck in a state.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>unresponsive</code>: My instance is unresponsive.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>not-accepting-credentials</code>: My instance is not accepting my
     *                     credentials.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>password-not-available</code>: A password is not available for my
     *                     instance.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>performance-network</code>: My instance is experiencing performance
     *                     problems that I believe are network related.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>performance-instance-store</code>: My instance is experiencing performance
     *                     problems that I believe are related to the instance stores.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>performance-ebs-volume</code>: My instance is experiencing performance
     *                     problems that I believe are related to an EBS volume.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>performance-other</code>: My instance is experiencing performance
     *                     problems.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>other</code>: [explain using the description parameter]</p>
     *             </li>
     *          </ul>
     */
    ReasonCodes: (ReportInstanceReasonCodes | string)[] | undefined;
    /**
     * <p>The time at which the reported instance health state began.</p>
     */
    StartTime?: Date;
    /**
     * <p>The status of all instances listed.</p>
     */
    Status: ReportStatusType | string | undefined;
}
export declare namespace ReportInstanceStatusRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReportInstanceStatusRequest) => any;
}
/**
 * <p>Contains the parameters for RequestSpotFleet.</p>
 */
export interface RequestSpotFleetRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The configuration for the Spot Fleet request.</p>
     */
    SpotFleetRequestConfig: SpotFleetRequestConfigData | undefined;
}
export declare namespace RequestSpotFleetRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RequestSpotFleetRequest) => any;
}
/**
 * <p>Contains the output of RequestSpotFleet.</p>
 */
export interface RequestSpotFleetResponse {
    /**
     * <p>The ID of the Spot Fleet request.</p>
     */
    SpotFleetRequestId?: string;
}
export declare namespace RequestSpotFleetResponse {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RequestSpotFleetResponse) => any;
}
/**
 * <p>Describes the launch specification for an instance.</p>
 */
export interface RequestSpotLaunchSpecification {
    /**
     * <p>One or more security group IDs.</p>
     */
    SecurityGroupIds?: string[];
    /**
     * <p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>
     */
    SecurityGroups?: string[];
    /**
     * <p>Deprecated.</p>
     */
    AddressingType?: string;
    /**
     * <p>One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value.
     *            This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume,
     *            it is not blank and its encryption status is used for the volume encryption status.</p>
     */
    BlockDeviceMappings?: BlockDeviceMapping[];
    /**
     * <p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
     *          <p>Default: <code>false</code>
     *          </p>
     */
    EbsOptimized?: boolean;
    /**
     * <p>The IAM instance profile.</p>
     */
    IamInstanceProfile?: IamInstanceProfileSpecification;
    /**
     * <p>The ID of the AMI.</p>
     */
    ImageId?: string;
    /**
     * <p>The instance type.</p>
     */
    InstanceType?: _InstanceType | string;
    /**
     * <p>The ID of the kernel.</p>
     */
    KernelId?: string;
    /**
     * <p>The name of the key pair.</p>
     */
    KeyName?: string;
    /**
     * <p>Indicates whether basic or detailed monitoring is enabled for the instance.</p>
     *          <p>Default: Disabled</p>
     */
    Monitoring?: RunInstancesMonitoringEnabled;
    /**
     * <p>One or more network interfaces. If you specify a network interface, you must specify
     *            subnet IDs and security group IDs using the network interface.</p>
     */
    NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
    /**
     * <p>The placement information for the instance.</p>
     */
    Placement?: SpotPlacement;
    /**
     * <p>The ID of the RAM disk.</p>
     */
    RamdiskId?: string;
    /**
     * <p>The ID of the subnet in which to launch the instance.</p>
     */
    SubnetId?: string;
    /**
     * <p>The Base64-encoded user data for the instance. User data is limited to 16 KB.</p>
     */
    UserData?: string;
}
export declare namespace RequestSpotLaunchSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RequestSpotLaunchSpecification) => any;
}
/**
 * <p>Contains the parameters for RequestSpotInstances.</p>
 */
export interface RequestSpotInstancesRequest {
    /**
     * <p>The user-specified name for a logical grouping of requests.</p>
     *         <p>When you specify an Availability Zone group in a Spot Instance request, all Spot
     *             Instances in the request are launched in the same Availability Zone. Instance proximity
     *             is maintained with this parameter, but the choice of Availability Zone is not. The group
     *             applies only to requests for Spot Instances of the same instance type. Any additional
     *             Spot Instance requests that are specified with the same Availability Zone group name are
     *             launched in that same Availability Zone, as long as at least one instance from the group
     *             is still active.</p>
     *         <p>If there is no active instance running in the Availability Zone group that you specify
     *             for a new Spot Instance request (all instances are terminated, the request is expired,
     *             or the maximum price you specified falls below current Spot price), then Amazon EC2 launches
     *             the instance in any Availability Zone where the constraint can be met. Consequently, the
     *             subsequent set of Spot Instances could be placed in a different zone from the original
     *             request, even if you specified the same Availability Zone group.</p>
     *         <p>Default: Instances are launched in any available Availability Zone.</p>
     */
    AvailabilityZoneGroup?: string;
    /**
     * <p>Deprecated.</p>
     */
    BlockDurationMinutes?: number;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *             request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *                 Idempotency</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     */
    ClientToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of Spot Instances to launch.</p>
     *         <p>Default: 1</p>
     */
    InstanceCount?: number;
    /**
     * <p>The instance launch group. Launch groups are Spot Instances that launch together and
     *             terminate together.</p>
     *         <p>Default: Instances are launched and terminated individually</p>
     */
    LaunchGroup?: string;
    /**
     * <p>The launch specification.</p>
     */
    LaunchSpecification?: RequestSpotLaunchSpecification;
    /**
     * <p>The maximum price per hour that you are willing to pay for a Spot Instance. The
     *             default is the On-Demand price.</p>
     */
    SpotPrice?: string;
    /**
     * <p>The Spot Instance request type.</p>
     *         <p>Default: <code>one-time</code>
     *         </p>
     */
    Type?: SpotInstanceType | string;
    /**
     * <p>The start date of the request. If this is a one-time request, the request becomes
     *             active at this date and time and remains active until all instances launch, the request
     *             expires, or the request is canceled. If the request is persistent, the request becomes
     *             active at this date and time and remains active until it expires or is canceled.</p>
     *         <p>The specified start date and time cannot be equal to the current date and time. You
     *             must specify a start date and time that occurs after the current date and time.</p>
     */
    ValidFrom?: Date;
    /**
     * <p>The end date of the request, in UTC format
     *                 (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     *         <ul>
     *             <li>
     *                 <p>For a persistent request, the request remains active until the
     *                         <code>ValidUntil</code> date and time is reached. Otherwise, the request
     *                     remains active until you cancel it. </p>
     *             </li>
     *             <li>
     *                 <p>For a one-time request, the request remains active until all instances launch,
     *                     the request is canceled, or the <code>ValidUntil</code> date and time is
     *                     reached. By default, the request is valid for 7 days from the date the request
     *                     was created.</p>
     *             </li>
     *          </ul>
     */
    ValidUntil?: Date;
    /**
     * <p>The key-value pair for tagging the Spot Instance request on creation. The value for
     *                 <code>ResourceType</code> must be <code>spot-instances-request</code>, otherwise the
     *             Spot Instance request fails. To tag the Spot Instance request after it has been created,
     *             see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>. </p>
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>
     */
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export declare namespace RequestSpotInstancesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RequestSpotInstancesRequest) => any;
}
/**
 * <p>Contains the output of RequestSpotInstances.</p>
 */
export interface RequestSpotInstancesResult {
    /**
     * <p>One or more Spot Instance requests.</p>
     */
    SpotInstanceRequests?: SpotInstanceRequest[];
}
export declare namespace RequestSpotInstancesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RequestSpotInstancesResult) => any;
}
export interface ResetAddressAttributeRequest {
    /**
     * <p>[EC2-VPC] The allocation ID.</p>
     */
    AllocationId: string | undefined;
    /**
     * <p>The attribute of the IP address.</p>
     */
    Attribute: AddressAttributeName | string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ResetAddressAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetAddressAttributeRequest) => any;
}
export interface ResetAddressAttributeResult {
    /**
     * <p>Information about the IP address.</p>
     */
    Address?: AddressAttribute;
}
export declare namespace ResetAddressAttributeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetAddressAttributeResult) => any;
}
export interface ResetEbsDefaultKmsKeyIdRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ResetEbsDefaultKmsKeyIdRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetEbsDefaultKmsKeyIdRequest) => any;
}
export interface ResetEbsDefaultKmsKeyIdResult {
    /**
     * <p>The Amazon Resource Name (ARN) of the default KMS key for EBS encryption by default.</p>
     */
    KmsKeyId?: string;
}
export declare namespace ResetEbsDefaultKmsKeyIdResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetEbsDefaultKmsKeyIdResult) => any;
}
export declare type ResetFpgaImageAttributeName = "loadPermission";
export interface ResetFpgaImageAttributeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the AFI.</p>
     */
    FpgaImageId: string | undefined;
    /**
     * <p>The attribute.</p>
     */
    Attribute?: ResetFpgaImageAttributeName | string;
}
export declare namespace ResetFpgaImageAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetFpgaImageAttributeRequest) => any;
}
export interface ResetFpgaImageAttributeResult {
    /**
     * <p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>
     */
    Return?: boolean;
}
export declare namespace ResetFpgaImageAttributeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetFpgaImageAttributeResult) => any;
}
export declare type ResetImageAttributeName = "launchPermission";
/**
 * <p>Contains the parameters for ResetImageAttribute.</p>
 */
export interface ResetImageAttributeRequest {
    /**
     * <p>The attribute to reset (currently you can only reset the launch permission attribute).</p>
     */
    Attribute: ResetImageAttributeName | string | undefined;
    /**
     * <p>The ID of the AMI.</p>
     */
    ImageId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *        and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *        Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ResetImageAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetImageAttributeRequest) => any;
}
export interface ResetInstanceAttributeRequest {
    /**
     * <p>The attribute to reset.</p>
     *         <important>
     *             <p>You can only reset the following attributes: <code>kernel</code> |
     *                     <code>ramdisk</code> | <code>sourceDestCheck</code>. To change an instance
     *                 attribute, use <a>ModifyInstanceAttribute</a>.</p>
     *         </important>
     */
    Attribute: InstanceAttributeName | string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId: string | undefined;
}
export declare namespace ResetInstanceAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetInstanceAttributeRequest) => any;
}
/**
 * <p>Contains the parameters for ResetNetworkInterfaceAttribute.</p>
 */
export interface ResetNetworkInterfaceAttributeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *             and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *             Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the network interface.</p>
     */
    NetworkInterfaceId: string | undefined;
    /**
     * <p>The source/destination checking attribute. Resets the value to <code>true</code>.</p>
     */
    SourceDestCheck?: string;
}
export declare namespace ResetNetworkInterfaceAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetNetworkInterfaceAttributeRequest) => any;
}
export interface ResetSnapshotAttributeRequest {
    /**
     * <p>The attribute to reset. Currently, only the attribute for permission to create volumes can
     *       be reset.</p>
     */
    Attribute: SnapshotAttributeName | string | undefined;
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ResetSnapshotAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResetSnapshotAttributeRequest) => any;
}
export interface RestoreAddressToClassicRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The Elastic IP address.</p>
     */
    PublicIp: string | undefined;
}
export declare namespace RestoreAddressToClassicRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RestoreAddressToClassicRequest) => any;
}
export interface RestoreAddressToClassicResult {
    /**
     * <p>The Elastic IP address.</p>
     */
    PublicIp?: string;
    /**
     * <p>The move status for the IP address.</p>
     */
    Status?: Status | string;
}
export declare namespace RestoreAddressToClassicResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RestoreAddressToClassicResult) => any;
}
export interface RestoreManagedPrefixListVersionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the prefix list.</p>
     */
    PrefixListId: string | undefined;
    /**
     * <p>The version to restore.</p>
     */
    PreviousVersion: number | undefined;
    /**
     * <p>The current version number for the prefix list.</p>
     */
    CurrentVersion: number | undefined;
}
export declare namespace RestoreManagedPrefixListVersionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RestoreManagedPrefixListVersionRequest) => any;
}
export interface RestoreManagedPrefixListVersionResult {
    /**
     * <p>Information about the prefix list.</p>
     */
    PrefixList?: ManagedPrefixList;
}
export declare namespace RestoreManagedPrefixListVersionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RestoreManagedPrefixListVersionResult) => any;
}
export interface RestoreSnapshotFromRecycleBinRequest {
    /**
     * <p>The ID of the snapshot to restore.</p>
     */
    SnapshotId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace RestoreSnapshotFromRecycleBinRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RestoreSnapshotFromRecycleBinRequest) => any;
}
export interface RestoreSnapshotFromRecycleBinResult {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The ARN of the Outpost on which the snapshot is stored. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">Amazon EBS local snapshots on Outposts</a> in the
     *       <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     */
    OutpostArn?: string;
    /**
     * <p>The description for the snapshot.</p>
     */
    Description?: string;
    /**
     * <p>Indicates whether the snapshot is encrypted.</p>
     */
    Encrypted?: boolean;
    /**
     * <p>The ID of the Amazon Web Services account that owns the EBS snapshot.</p>
     */
    OwnerId?: string;
    /**
     * <p>The progress of the snapshot, as a percentage.</p>
     */
    Progress?: string;
    /**
     * <p>The time stamp when the snapshot was initiated.</p>
     */
    StartTime?: Date;
    /**
     * <p>The state of the snapshot.</p>
     */
    State?: SnapshotState | string;
    /**
     * <p>The ID of the volume that was used to create the snapshot.</p>
     */
    VolumeId?: string;
    /**
     * <p>The size of the volume, in GiB.</p>
     */
    VolumeSize?: number;
}
export declare namespace RestoreSnapshotFromRecycleBinResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RestoreSnapshotFromRecycleBinResult) => any;
}
export interface RestoreSnapshotTierRequest {
    /**
     * <p>The ID of the snapshot to restore.</p>
     */
    SnapshotId: string | undefined;
    /**
     * <p>Specifies the number of days for which to temporarily restore an archived snapshot.
     *       Required for temporary restores only. The snapshot will be automatically re-archived
     *       after this period.</p>
     *          <p>To temporarily restore an archived snapshot, specify the number of days and omit
     *       the <b>PermanentRestore</b> parameter or set it to
     *       <code>false</code>.</p>
     */
    TemporaryRestoreDays?: number;
    /**
     * <p>Indicates whether to permanently restore an archived snapshot. To permanently restore
     *       an archived snapshot, specify <code>true</code> and omit the
     *       <b>RestoreSnapshotTierRequest$TemporaryRestoreDays</b> parameter.</p>
     */
    PermanentRestore?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace RestoreSnapshotTierRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RestoreSnapshotTierRequest) => any;
}
export interface RestoreSnapshotTierResult {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The date and time when the snapshot restore process started.</p>
     */
    RestoreStartTime?: Date;
    /**
     * <p>For temporary restores only. The number of days for which the archived snapshot
     *       is temporarily restored.</p>
     */
    RestoreDuration?: number;
    /**
     * <p>Indicates whether the snapshot is permanently restored. <code>true</code> indicates a permanent
     *       restore. <code>false</code> indicates a temporary restore.</p>
     */
    IsPermanentRestore?: boolean;
}
export declare namespace RestoreSnapshotTierResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RestoreSnapshotTierResult) => any;
}
export interface RevokeClientVpnIngressRequest {
    /**
     * <p>The ID of the Client VPN endpoint with which the authorization rule is associated.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>The IPv4 address range, in CIDR notation, of the network for which access is being removed.</p>
     */
    TargetNetworkCidr: string | undefined;
    /**
     * <p>The ID of the Active Directory group for which to revoke access. </p>
     */
    AccessGroupId?: string;
    /**
     * <p>Indicates whether access should be revoked for all clients.</p>
     */
    RevokeAllGroups?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace RevokeClientVpnIngressRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RevokeClientVpnIngressRequest) => any;
}
export interface RevokeClientVpnIngressResult {
    /**
     * <p>The current state of the authorization rule.</p>
     */
    Status?: ClientVpnAuthorizationRuleStatus;
}
export declare namespace RevokeClientVpnIngressResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RevokeClientVpnIngressResult) => any;
}
export interface RevokeSecurityGroupEgressRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the security group.</p>
     */
    GroupId: string | undefined;
    /**
     * <p>The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions.</p>
     */
    IpPermissions?: IpPermission[];
    /**
     * <p>The IDs of the security group rules.</p>
     */
    SecurityGroupRuleIds?: string[];
    /**
     * <p>Not supported. Use a set of IP permissions to specify the CIDR.</p>
     */
    CidrIp?: string;
    /**
     * <p>Not supported. Use a set of IP permissions to specify the port.</p>
     */
    FromPort?: number;
    /**
     * <p>Not supported. Use a set of IP permissions to specify the protocol name or
     *             number.</p>
     */
    IpProtocol?: string;
    /**
     * <p>Not supported. Use a set of IP permissions to specify the port.</p>
     */
    ToPort?: number;
    /**
     * <p>Not supported. Use a set of IP permissions to specify a
     *            destination security group.</p>
     */
    SourceSecurityGroupName?: string;
    /**
     * <p>Not supported. Use a set of IP permissions to specify a destination security
     *             group.</p>
     */
    SourceSecurityGroupOwnerId?: string;
}
export declare namespace RevokeSecurityGroupEgressRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RevokeSecurityGroupEgressRequest) => any;
}
export interface RevokeSecurityGroupEgressResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>
     */
    Return?: boolean;
    /**
     * <p>The outbound rules that were unknown to the service. In some cases,
     *                 <code>unknownIpPermissionSet</code> might be in a different format from the request
     *             parameter. </p>
     */
    UnknownIpPermissions?: IpPermission[];
}
export declare namespace RevokeSecurityGroupEgressResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RevokeSecurityGroupEgressResult) => any;
}
export interface RevokeSecurityGroupIngressRequest {
    /**
     * <p>The CIDR IP address range. You can't specify this parameter when specifying a source security group.</p>
     */
    CidrIp?: string;
    /**
     * <p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number,
     *         use <code>-1</code> to specify all ICMP types.</p>
     */
    FromPort?: number;
    /**
     * <p>The ID of the security group. You must specify either the security group ID or the
     *            security group name in the request. For security groups in a nondefault VPC, you must
     *            specify the security group ID.</p>
     */
    GroupId?: string;
    /**
     * <p>[EC2-Classic, default VPC] The name of the security group. You must specify either the
     *            security group ID or the security group name in the request.</p>
     */
    GroupName?: string;
    /**
     * <p>The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same set of permissions.</p>
     */
    IpPermissions?: IpPermission[];
    /**
     * <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number
     *         (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     *         Use <code>-1</code> to specify all.</p>
     */
    IpProtocol?: string;
    /**
     * <p>[EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.</p>
     */
    SourceSecurityGroupName?: string;
    /**
     * <p>[EC2-Classic] The Amazon Web Services account ID of the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.</p>
     */
    SourceSecurityGroupOwnerId?: string;
    /**
     * <p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number,
     *         use <code>-1</code> to specify all ICMP codes for the ICMP type.</p>
     */
    ToPort?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the security group rules.</p>
     */
    SecurityGroupRuleIds?: string[];
}
export declare namespace RevokeSecurityGroupIngressRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RevokeSecurityGroupIngressRequest) => any;
}
export interface RevokeSecurityGroupIngressResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>
     */
    Return?: boolean;
    /**
     * <p>The inbound rules that were unknown to the service. In some cases,
     *                 <code>unknownIpPermissionSet</code> might be in a different format from the request
     *             parameter. </p>
     */
    UnknownIpPermissions?: IpPermission[];
}
export declare namespace RevokeSecurityGroupIngressResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RevokeSecurityGroupIngressResult) => any;
}
/**
 * <p>The CPU options for the instance. Both the core count and threads per core must be
 *             specified in the request.</p>
 */
export interface CpuOptionsRequest {
    /**
     * <p>The number of CPU cores for the instance.</p>
     */
    CoreCount?: number;
    /**
     * <p>The number of threads per CPU core. To disable multithreading for
     *             the instance, specify a value of <code>1</code>. Otherwise, specify the default value of
     *                 <code>2</code>.</p>
     */
    ThreadsPerCore?: number;
}
export declare namespace CpuOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CpuOptionsRequest) => any;
}
/**
 * <p>
 *            Describes an elastic inference accelerator.
 *         </p>
 */
export interface ElasticInferenceAccelerator {
    /**
     * <p>
     *         	The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>, <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>, and <code>eia2.xlarge</code>.
     *         </p>
     */
    Type: string | undefined;
    /**
     * <p>
     *             The number of elastic inference accelerators to attach to the instance.
     *         </p>
     *          <p>Default: 1</p>
     */
    Count?: number;
}
export declare namespace ElasticInferenceAccelerator {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ElasticInferenceAccelerator) => any;
}
/**
 * <p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information,
 *     		see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">
 *     		    What is Amazon Web Services Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p>
 */
export interface EnclaveOptionsRequest {
    /**
     * <p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>.</p>
     */
    Enabled?: boolean;
}
export declare namespace EnclaveOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnclaveOptionsRequest) => any;
}
/**
 * <p>Indicates whether your instance is configured for hibernation. This parameter is valid
 *             only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation
 *                 prerequisites</a>. For
 *             more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the
 *                 <i>Amazon EC2 User Guide</i>.</p>
 */
export interface HibernationOptionsRequest {
    /**
     * <p>If you set this parameter to <code>true</code>, your instance is enabled for
     *             hibernation.</p>
     *         <p>Default: <code>false</code>
     *          </p>
     */
    Configured?: boolean;
}
export declare namespace HibernationOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: HibernationOptionsRequest) => any;
}
/**
 * <p>The options for Spot Instances.</p>
 */
export interface SpotMarketOptions {
    /**
     * <p>The maximum hourly price you're willing to pay for the Spot Instances. The default is
     *             the On-Demand price.</p>
     */
    MaxPrice?: string;
    /**
     * <p>The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent Spot
     *             Instance requests are only supported when the instance interruption behavior is either <code>hibernate</code> or
     *                 <code>stop</code>.</p>
     */
    SpotInstanceType?: SpotInstanceType | string;
    /**
     * <p>Deprecated.</p>
     */
    BlockDurationMinutes?: number;
    /**
     * <p>The end date of the request, in UTC format
     *                 (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *             Supported only for persistent requests.</p>
     *         <ul>
     *             <li>
     *                 <p>For a persistent request, the request remains active until the
     *                         <code>ValidUntil</code> date and time is reached. Otherwise, the request
     *                     remains active until you cancel it.</p>
     *             </li>
     *             <li>
     *                 <p>For a one-time request, <code>ValidUntil</code> is not supported. The request
     *                     remains active until all instances launch or you cancel the request.</p>
     *             </li>
     *          </ul>
     */
    ValidUntil?: Date;
    /**
     * <p>The behavior when a Spot Instance is interrupted. The default is
     *                 <code>terminate</code>.</p>
     */
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export declare namespace SpotMarketOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotMarketOptions) => any;
}
/**
 * <p>Describes the market (purchasing) option for the instances.</p>
 */
export interface InstanceMarketOptionsRequest {
    /**
     * <p>The market type.</p>
     */
    MarketType?: MarketType | string;
    /**
     * <p>The options for Spot Instances.</p>
     */
    SpotOptions?: SpotMarketOptions;
}
export declare namespace InstanceMarketOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceMarketOptionsRequest) => any;
}
