import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ReplaceRouteRequest } from "../models/models_5";
export interface ReplaceRouteCommandInput extends ReplaceRouteRequest {
}
export interface ReplaceRouteCommandOutput extends __MetadataBearer {
}
/**
 * <p>Replaces an existing route within a route table in a VPC. You must provide only one of
 *             the following: internet gateway, virtual private gateway, NAT instance, NAT gateway, VPC
 *             peering connection, network interface, egress-only internet gateway, or transit
 *             gateway.</p>
 *         <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the
 *                 <i>Amazon Virtual Private Cloud User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ReplaceRouteCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ReplaceRouteCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ReplaceRouteCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ReplaceRouteCommandInput} for command's `input` shape.
 * @see {@link ReplaceRouteCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ReplaceRouteCommand extends $Command<ReplaceRouteCommandInput, ReplaceRouteCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ReplaceRouteCommandInput;
    constructor(input: ReplaceRouteCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ReplaceRouteCommandInput, ReplaceRouteCommandOutput>;
    private serialize;
    private deserialize;
}
