import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ProvisionIpamPoolCidrRequest, ProvisionIpamPoolCidrResult } from "../models/models_5";
export interface ProvisionIpamPoolCidrCommandInput extends ProvisionIpamPoolCidrRequest {
}
export interface ProvisionIpamPoolCidrCommandOutput extends ProvisionIpamPoolCidrResult, __MetadataBearer {
}
/**
 * <p>Provision a CIDR to an IPAM pool. You can use thsi action to provision new CIDRs to a top-level pool or to transfer a CIDR from a top-level pool to a pool within it.</p>
 *          <p>For more information, see <a href="/vpc/latest/ipam/prov-cidr-ipam.html">Provision CIDRs to pools</a> in the <i>Amazon VPC IPAM User Guide</i>.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ProvisionIpamPoolCidrCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ProvisionIpamPoolCidrCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ProvisionIpamPoolCidrCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ProvisionIpamPoolCidrCommandInput} for command's `input` shape.
 * @see {@link ProvisionIpamPoolCidrCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ProvisionIpamPoolCidrCommand extends $Command<ProvisionIpamPoolCidrCommandInput, ProvisionIpamPoolCidrCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ProvisionIpamPoolCidrCommandInput;
    constructor(input: ProvisionIpamPoolCidrCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ProvisionIpamPoolCidrCommandInput, ProvisionIpamPoolCidrCommandOutput>;
    private serialize;
    private deserialize;
}
