import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyIpamScopeRequest, ModifyIpamScopeResult } from "../models/models_5";
export interface ModifyIpamScopeCommandInput extends ModifyIpamScopeRequest {
}
export interface ModifyIpamScopeCommandOutput extends ModifyIpamScopeResult, __MetadataBearer {
}
/**
 * <p>Modify an IPAM scope.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyIpamScopeCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyIpamScopeCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifyIpamScopeCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifyIpamScopeCommandInput} for command's `input` shape.
 * @see {@link ModifyIpamScopeCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifyIpamScopeCommand extends $Command<ModifyIpamScopeCommandInput, ModifyIpamScopeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyIpamScopeCommandInput;
    constructor(input: ModifyIpamScopeCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyIpamScopeCommandInput, ModifyIpamScopeCommandOutput>;
    private serialize;
    private deserialize;
}
