import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyIpamPoolRequest, ModifyIpamPoolResult } from "../models/models_5";
export interface ModifyIpamPoolCommandInput extends ModifyIpamPoolRequest {
}
export interface ModifyIpamPoolCommandOutput extends ModifyIpamPoolResult, __MetadataBearer {
}
/**
 * <p>Modify the configurations of an IPAM pool.</p>
 *          <p>For more information, see <a href="/vpc/latest/ipam/mod-pool-ipam.html">Modify a pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyIpamPoolCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyIpamPoolCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifyIpamPoolCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifyIpamPoolCommandInput} for command's `input` shape.
 * @see {@link ModifyIpamPoolCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifyIpamPoolCommand extends $Command<ModifyIpamPoolCommandInput, ModifyIpamPoolCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyIpamPoolCommandInput;
    constructor(input: ModifyIpamPoolCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyIpamPoolCommandInput, ModifyIpamPoolCommandOutput>;
    private serialize;
    private deserialize;
}
