import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyIpamRequest, ModifyIpamResult } from "../models/models_5";
export interface ModifyIpamCommandInput extends ModifyIpamRequest {
}
export interface ModifyIpamCommandOutput extends ModifyIpamResult, __MetadataBearer {
}
/**
 * <p>Modify the configurations of an IPAM.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyIpamCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyIpamCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifyIpamCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifyIpamCommandInput} for command's `input` shape.
 * @see {@link ModifyIpamCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifyIpamCommand extends $Command<ModifyIpamCommandInput, ModifyIpamCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyIpamCommandInput;
    constructor(input: ModifyIpamCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyIpamCommandInput, ModifyIpamCommandOutput>;
    private serialize;
    private deserialize;
}
