import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisassociateInstanceEventWindowRequest, DisassociateInstanceEventWindowResult } from "../models/models_4";
export interface DisassociateInstanceEventWindowCommandInput extends DisassociateInstanceEventWindowRequest {
}
export interface DisassociateInstanceEventWindowCommandOutput extends DisassociateInstanceEventWindowResult, __MetadataBearer {
}
/**
 * <p>Disassociates one or more targets from an event window.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
 *             events</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisassociateInstanceEventWindowCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisassociateInstanceEventWindowCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DisassociateInstanceEventWindowCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DisassociateInstanceEventWindowCommandInput} for command's `input` shape.
 * @see {@link DisassociateInstanceEventWindowCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DisassociateInstanceEventWindowCommand extends $Command<DisassociateInstanceEventWindowCommandInput, DisassociateInstanceEventWindowCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DisassociateInstanceEventWindowCommandInput;
    constructor(input: DisassociateInstanceEventWindowCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DisassociateInstanceEventWindowCommandInput, DisassociateInstanceEventWindowCommandOutput>;
    private serialize;
    private deserialize;
}
