import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeletePublicIpv4PoolRequest, DeletePublicIpv4PoolResult } from "../models/models_2";
export interface DeletePublicIpv4PoolCommandInput extends DeletePublicIpv4PoolRequest {
}
export interface DeletePublicIpv4PoolCommandOutput extends DeletePublicIpv4PoolResult, __MetadataBearer {
}
/**
 * <p>Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeletePublicIpv4PoolCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeletePublicIpv4PoolCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DeletePublicIpv4PoolCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeletePublicIpv4PoolCommandInput} for command's `input` shape.
 * @see {@link DeletePublicIpv4PoolCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DeletePublicIpv4PoolCommand extends $Command<DeletePublicIpv4PoolCommandInput, DeletePublicIpv4PoolCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeletePublicIpv4PoolCommandInput;
    constructor(input: DeletePublicIpv4PoolCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeletePublicIpv4PoolCommandInput, DeletePublicIpv4PoolCommandOutput>;
    private serialize;
    private deserialize;
}
