import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateSubnetRequest, CreateSubnetResult } from "../models/models_1";
export interface CreateSubnetCommandInput extends CreateSubnetRequest {
}
export interface CreateSubnetCommandOutput extends CreateSubnetResult, __MetadataBearer {
}
/**
 * <p>Creates a subnet in a specified VPC.</p>
 *         <p>You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you
 *             can't change its CIDR block. The allowed block size is between a /16 netmask (65,536 IP
 *             addresses) and /28 netmask (16 IP addresses). The CIDR block must not overlap with the
 *             CIDR block of an existing subnet in the VPC.</p>
 *         <p>If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an
 *             IPv6 CIDR block that uses a /64 prefix length. </p>
 *         <important>
 *             <p>Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
 *                 block. They're not available for use.</p>
 *         </important>
 *         <p>If you add more than one subnet to a VPC, they're set up in a star topology with a
 *             logical router in the middle.</p>
 *         <p>When you stop an instance in a subnet, it retains its private IPv4 address. It's
 *             therefore possible to have a subnet with no running instances (they're all stopped), but
 *             no remaining IP addresses available.</p>
 *         <p>For more information about subnets, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets</a> in the
 *                 <i>Amazon Virtual Private Cloud User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateSubnetCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateSubnetCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateSubnetCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateSubnetCommandInput} for command's `input` shape.
 * @see {@link CreateSubnetCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateSubnetCommand extends $Command<CreateSubnetCommandInput, CreateSubnetCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateSubnetCommandInput;
    constructor(input: CreateSubnetCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateSubnetCommandInput, CreateSubnetCommandOutput>;
    private serialize;
    private deserialize;
}
