import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateManagedPrefixListRequest, CreateManagedPrefixListResult } from "../models/models_1";
export interface CreateManagedPrefixListCommandInput extends CreateManagedPrefixListRequest {
}
export interface CreateManagedPrefixListCommandOutput extends CreateManagedPrefixListResult, __MetadataBearer {
}
/**
 * <p>Creates a managed prefix list. You can specify one or more entries for the prefix list.
 *             Each entry consists of a CIDR block and an optional description.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateManagedPrefixListCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateManagedPrefixListCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateManagedPrefixListCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateManagedPrefixListCommandInput} for command's `input` shape.
 * @see {@link CreateManagedPrefixListCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateManagedPrefixListCommand extends $Command<CreateManagedPrefixListCommandInput, CreateManagedPrefixListCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateManagedPrefixListCommandInput;
    constructor(input: CreateManagedPrefixListCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateManagedPrefixListCommandInput, CreateManagedPrefixListCommandOutput>;
    private serialize;
    private deserialize;
}
