import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateCapacityReservationFleetRequest, CreateCapacityReservationFleetResult } from "../models/models_0";
export interface CreateCapacityReservationFleetCommandInput extends CreateCapacityReservationFleetRequest {
}
export interface CreateCapacityReservationFleetCommandOutput extends CreateCapacityReservationFleetResult, __MetadataBearer {
}
/**
 * <p>Creates a Capacity Reservation Fleet. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a Capacity
 * 			Reservation Fleet</a> in the Amazon EC2 User Guide.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateCapacityReservationFleetCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateCapacityReservationFleetCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateCapacityReservationFleetCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateCapacityReservationFleetCommandInput} for command's `input` shape.
 * @see {@link CreateCapacityReservationFleetCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateCapacityReservationFleetCommand extends $Command<CreateCapacityReservationFleetCommandInput, CreateCapacityReservationFleetCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateCapacityReservationFleetCommandInput;
    constructor(input: CreateCapacityReservationFleetCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateCapacityReservationFleetCommandInput, CreateCapacityReservationFleetCommandOutput>;
    private serialize;
    private deserialize;
}
