import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CancelCapacityReservationFleetsRequest, CancelCapacityReservationFleetsResult } from "../models/models_0";
export interface CancelCapacityReservationFleetsCommandInput extends CancelCapacityReservationFleetsRequest {
}
export interface CancelCapacityReservationFleetsCommandOutput extends CancelCapacityReservationFleetsResult, __MetadataBearer {
}
/**
 * <p>Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation
 * 			Fleet, the following happens:</p>
 * 		       <ul>
 *             <li>
 * 				           <p>The Capacity Reservation Fleet's status changes to <code>cancelled</code>.</p>
 * 			         </li>
 *             <li>
 * 				           <p>The individual Capacity Reservations in the Fleet are cancelled. Instances running
 * 					in the Capacity Reservations at the time of cancelling the Fleet continue to run in
 * 					shared capacity.</p>
 * 			         </li>
 *             <li>
 * 				           <p>The Fleet stops creating new Capacity Reservations.</p>
 * 			         </li>
 *          </ul>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CancelCapacityReservationFleetsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CancelCapacityReservationFleetsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CancelCapacityReservationFleetsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CancelCapacityReservationFleetsCommandInput} for command's `input` shape.
 * @see {@link CancelCapacityReservationFleetsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CancelCapacityReservationFleetsCommand extends $Command<CancelCapacityReservationFleetsCommandInput, CancelCapacityReservationFleetsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CancelCapacityReservationFleetsCommandInput;
    constructor(input: CancelCapacityReservationFleetsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CancelCapacityReservationFleetsCommandInput, CancelCapacityReservationFleetsCommandOutput>;
    private serialize;
    private deserialize;
}
