import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { UpdateSecurityGroupRuleDescriptionsEgressRequest, UpdateSecurityGroupRuleDescriptionsEgressResult, } from "../models/models_6";
import { deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressCommand, serializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressCommand, } from "../protocols/Aws_ec2";
var UpdateSecurityGroupRuleDescriptionsEgressCommand = (function (_super) {
    __extends(UpdateSecurityGroupRuleDescriptionsEgressCommand, _super);
    function UpdateSecurityGroupRuleDescriptionsEgressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    UpdateSecurityGroupRuleDescriptionsEgressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "UpdateSecurityGroupRuleDescriptionsEgressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: UpdateSecurityGroupRuleDescriptionsEgressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: UpdateSecurityGroupRuleDescriptionsEgressResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    UpdateSecurityGroupRuleDescriptionsEgressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressCommand(input, context);
    };
    UpdateSecurityGroupRuleDescriptionsEgressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressCommand(output, context);
    };
    return UpdateSecurityGroupRuleDescriptionsEgressCommand;
}($Command));
export { UpdateSecurityGroupRuleDescriptionsEgressCommand };
