import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { UnassignIpv6AddressesRequest, UnassignIpv6AddressesResult } from "../models/models_6";
import { deserializeAws_ec2UnassignIpv6AddressesCommand, serializeAws_ec2UnassignIpv6AddressesCommand, } from "../protocols/Aws_ec2";
var UnassignIpv6AddressesCommand = (function (_super) {
    __extends(UnassignIpv6AddressesCommand, _super);
    function UnassignIpv6AddressesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    UnassignIpv6AddressesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "UnassignIpv6AddressesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: UnassignIpv6AddressesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: UnassignIpv6AddressesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    UnassignIpv6AddressesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2UnassignIpv6AddressesCommand(input, context);
    };
    UnassignIpv6AddressesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2UnassignIpv6AddressesCommand(output, context);
    };
    return UnassignIpv6AddressesCommand;
}($Command));
export { UnassignIpv6AddressesCommand };
