import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { TerminateClientVpnConnectionsRequest, TerminateClientVpnConnectionsResult } from "../models/models_6";
import { deserializeAws_ec2TerminateClientVpnConnectionsCommand, serializeAws_ec2TerminateClientVpnConnectionsCommand, } from "../protocols/Aws_ec2";
var TerminateClientVpnConnectionsCommand = (function (_super) {
    __extends(TerminateClientVpnConnectionsCommand, _super);
    function TerminateClientVpnConnectionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    TerminateClientVpnConnectionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "TerminateClientVpnConnectionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: TerminateClientVpnConnectionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: TerminateClientVpnConnectionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    TerminateClientVpnConnectionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2TerminateClientVpnConnectionsCommand(input, context);
    };
    TerminateClientVpnConnectionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2TerminateClientVpnConnectionsCommand(output, context);
    };
    return TerminateClientVpnConnectionsCommand;
}($Command));
export { TerminateClientVpnConnectionsCommand };
