import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { SearchTransitGatewayRoutesRequest, SearchTransitGatewayRoutesResult } from "../models/models_6";
import { deserializeAws_ec2SearchTransitGatewayRoutesCommand, serializeAws_ec2SearchTransitGatewayRoutesCommand, } from "../protocols/Aws_ec2";
var SearchTransitGatewayRoutesCommand = (function (_super) {
    __extends(SearchTransitGatewayRoutesCommand, _super);
    function SearchTransitGatewayRoutesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    SearchTransitGatewayRoutesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "SearchTransitGatewayRoutesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: SearchTransitGatewayRoutesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: SearchTransitGatewayRoutesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    SearchTransitGatewayRoutesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2SearchTransitGatewayRoutesCommand(input, context);
    };
    SearchTransitGatewayRoutesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2SearchTransitGatewayRoutesCommand(output, context);
    };
    return SearchTransitGatewayRoutesCommand;
}($Command));
export { SearchTransitGatewayRoutesCommand };
