import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { SearchTransitGatewayMulticastGroupsRequest, SearchTransitGatewayMulticastGroupsResult, } from "../models/models_6";
import { deserializeAws_ec2SearchTransitGatewayMulticastGroupsCommand, serializeAws_ec2SearchTransitGatewayMulticastGroupsCommand, } from "../protocols/Aws_ec2";
var SearchTransitGatewayMulticastGroupsCommand = (function (_super) {
    __extends(SearchTransitGatewayMulticastGroupsCommand, _super);
    function SearchTransitGatewayMulticastGroupsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    SearchTransitGatewayMulticastGroupsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "SearchTransitGatewayMulticastGroupsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: SearchTransitGatewayMulticastGroupsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: SearchTransitGatewayMulticastGroupsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    SearchTransitGatewayMulticastGroupsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2SearchTransitGatewayMulticastGroupsCommand(input, context);
    };
    SearchTransitGatewayMulticastGroupsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2SearchTransitGatewayMulticastGroupsCommand(output, context);
    };
    return SearchTransitGatewayMulticastGroupsCommand;
}($Command));
export { SearchTransitGatewayMulticastGroupsCommand };
