import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { SearchLocalGatewayRoutesRequest, SearchLocalGatewayRoutesResult } from "../models/models_6";
import { deserializeAws_ec2SearchLocalGatewayRoutesCommand, serializeAws_ec2SearchLocalGatewayRoutesCommand, } from "../protocols/Aws_ec2";
var SearchLocalGatewayRoutesCommand = (function (_super) {
    __extends(SearchLocalGatewayRoutesCommand, _super);
    function SearchLocalGatewayRoutesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    SearchLocalGatewayRoutesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "SearchLocalGatewayRoutesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: SearchLocalGatewayRoutesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: SearchLocalGatewayRoutesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    SearchLocalGatewayRoutesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2SearchLocalGatewayRoutesCommand(input, context);
    };
    SearchLocalGatewayRoutesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2SearchLocalGatewayRoutesCommand(output, context);
    };
    return SearchLocalGatewayRoutesCommand;
}($Command));
export { SearchLocalGatewayRoutesCommand };
