import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RevokeSecurityGroupEgressRequest, RevokeSecurityGroupEgressResult } from "../models/models_5";
import { deserializeAws_ec2RevokeSecurityGroupEgressCommand, serializeAws_ec2RevokeSecurityGroupEgressCommand, } from "../protocols/Aws_ec2";
var RevokeSecurityGroupEgressCommand = (function (_super) {
    __extends(RevokeSecurityGroupEgressCommand, _super);
    function RevokeSecurityGroupEgressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RevokeSecurityGroupEgressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RevokeSecurityGroupEgressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RevokeSecurityGroupEgressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RevokeSecurityGroupEgressResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RevokeSecurityGroupEgressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RevokeSecurityGroupEgressCommand(input, context);
    };
    RevokeSecurityGroupEgressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RevokeSecurityGroupEgressCommand(output, context);
    };
    return RevokeSecurityGroupEgressCommand;
}($Command));
export { RevokeSecurityGroupEgressCommand };
