import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ResetSnapshotAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ResetSnapshotAttributeCommand, serializeAws_ec2ResetSnapshotAttributeCommand, } from "../protocols/Aws_ec2";
var ResetSnapshotAttributeCommand = (function (_super) {
    __extends(ResetSnapshotAttributeCommand, _super);
    function ResetSnapshotAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ResetSnapshotAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ResetSnapshotAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ResetSnapshotAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ResetSnapshotAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ResetSnapshotAttributeCommand(input, context);
    };
    ResetSnapshotAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ResetSnapshotAttributeCommand(output, context);
    };
    return ResetSnapshotAttributeCommand;
}($Command));
export { ResetSnapshotAttributeCommand };
