import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ResetInstanceAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ResetInstanceAttributeCommand, serializeAws_ec2ResetInstanceAttributeCommand, } from "../protocols/Aws_ec2";
var ResetInstanceAttributeCommand = (function (_super) {
    __extends(ResetInstanceAttributeCommand, _super);
    function ResetInstanceAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ResetInstanceAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ResetInstanceAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ResetInstanceAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ResetInstanceAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ResetInstanceAttributeCommand(input, context);
    };
    ResetInstanceAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ResetInstanceAttributeCommand(output, context);
    };
    return ResetInstanceAttributeCommand;
}($Command));
export { ResetInstanceAttributeCommand };
