import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ResetImageAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ResetImageAttributeCommand, serializeAws_ec2ResetImageAttributeCommand, } from "../protocols/Aws_ec2";
var ResetImageAttributeCommand = (function (_super) {
    __extends(ResetImageAttributeCommand, _super);
    function ResetImageAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ResetImageAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ResetImageAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ResetImageAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ResetImageAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ResetImageAttributeCommand(input, context);
    };
    ResetImageAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ResetImageAttributeCommand(output, context);
    };
    return ResetImageAttributeCommand;
}($Command));
export { ResetImageAttributeCommand };
