import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ResetAddressAttributeRequest, ResetAddressAttributeResult } from "../models/models_5";
import { deserializeAws_ec2ResetAddressAttributeCommand, serializeAws_ec2ResetAddressAttributeCommand, } from "../protocols/Aws_ec2";
var ResetAddressAttributeCommand = (function (_super) {
    __extends(ResetAddressAttributeCommand, _super);
    function ResetAddressAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ResetAddressAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ResetAddressAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ResetAddressAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ResetAddressAttributeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ResetAddressAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ResetAddressAttributeCommand(input, context);
    };
    ResetAddressAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ResetAddressAttributeCommand(output, context);
    };
    return ResetAddressAttributeCommand;
}($Command));
export { ResetAddressAttributeCommand };
