import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReplaceNetworkAclEntryRequest } from "../models/models_5";
import { deserializeAws_ec2ReplaceNetworkAclEntryCommand, serializeAws_ec2ReplaceNetworkAclEntryCommand, } from "../protocols/Aws_ec2";
var ReplaceNetworkAclEntryCommand = (function (_super) {
    __extends(ReplaceNetworkAclEntryCommand, _super);
    function ReplaceNetworkAclEntryCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReplaceNetworkAclEntryCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ReplaceNetworkAclEntryCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReplaceNetworkAclEntryRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReplaceNetworkAclEntryCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ReplaceNetworkAclEntryCommand(input, context);
    };
    ReplaceNetworkAclEntryCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ReplaceNetworkAclEntryCommand(output, context);
    };
    return ReplaceNetworkAclEntryCommand;
}($Command));
export { ReplaceNetworkAclEntryCommand };
