import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReleaseIpamPoolAllocationRequest, ReleaseIpamPoolAllocationResult } from "../models/models_5";
import { deserializeAws_ec2ReleaseIpamPoolAllocationCommand, serializeAws_ec2ReleaseIpamPoolAllocationCommand, } from "../protocols/Aws_ec2";
var ReleaseIpamPoolAllocationCommand = (function (_super) {
    __extends(ReleaseIpamPoolAllocationCommand, _super);
    function ReleaseIpamPoolAllocationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReleaseIpamPoolAllocationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ReleaseIpamPoolAllocationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReleaseIpamPoolAllocationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ReleaseIpamPoolAllocationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReleaseIpamPoolAllocationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ReleaseIpamPoolAllocationCommand(input, context);
    };
    ReleaseIpamPoolAllocationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ReleaseIpamPoolAllocationCommand(output, context);
    };
    return ReleaseIpamPoolAllocationCommand;
}($Command));
export { ReleaseIpamPoolAllocationCommand };
