import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RejectVpcPeeringConnectionRequest, RejectVpcPeeringConnectionResult } from "../models/models_5";
import { deserializeAws_ec2RejectVpcPeeringConnectionCommand, serializeAws_ec2RejectVpcPeeringConnectionCommand, } from "../protocols/Aws_ec2";
var RejectVpcPeeringConnectionCommand = (function (_super) {
    __extends(RejectVpcPeeringConnectionCommand, _super);
    function RejectVpcPeeringConnectionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RejectVpcPeeringConnectionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RejectVpcPeeringConnectionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RejectVpcPeeringConnectionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RejectVpcPeeringConnectionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RejectVpcPeeringConnectionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RejectVpcPeeringConnectionCommand(input, context);
    };
    RejectVpcPeeringConnectionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RejectVpcPeeringConnectionCommand(output, context);
    };
    return RejectVpcPeeringConnectionCommand;
}($Command));
export { RejectVpcPeeringConnectionCommand };
