import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RejectVpcEndpointConnectionsRequest, RejectVpcEndpointConnectionsResult } from "../models/models_5";
import { deserializeAws_ec2RejectVpcEndpointConnectionsCommand, serializeAws_ec2RejectVpcEndpointConnectionsCommand, } from "../protocols/Aws_ec2";
var RejectVpcEndpointConnectionsCommand = (function (_super) {
    __extends(RejectVpcEndpointConnectionsCommand, _super);
    function RejectVpcEndpointConnectionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RejectVpcEndpointConnectionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RejectVpcEndpointConnectionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RejectVpcEndpointConnectionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RejectVpcEndpointConnectionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RejectVpcEndpointConnectionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RejectVpcEndpointConnectionsCommand(input, context);
    };
    RejectVpcEndpointConnectionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RejectVpcEndpointConnectionsCommand(output, context);
    };
    return RejectVpcEndpointConnectionsCommand;
}($Command));
export { RejectVpcEndpointConnectionsCommand };
